/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.tile.TileEntityItemShelf;

public class BlockItemShelf
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);

    public BlockItemShelf() {
        super(Material.field_151575_d);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            default: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: 
        }
        return NORTH_AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (hand == EnumHand.MAIN_HAND && (te = world.func_175625_s(pos)) instanceof TileEntityItemShelf) {
            TileEntityItemShelf shelf = (TileEntityItemShelf)te;
            Vec3i up = new Vec3i(0, 1, 0);
            Vec3i dir = up.func_177955_d(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176730_m());
            float cx = (float)dir.func_177958_n() * hitX + (float)dir.func_177952_p() * hitZ;
            float cy = hitY;
            if (cx < 0.0f) {
                cx += 1.0f;
            }
            int slot = 0;
            if ((double)cx >= 0.0 && (double)cx <= 0.5) {
                ++slot;
            }
            if ((double)cy >= 0.0 && (double)cy <= 0.5) {
                slot += 2;
            }
            InvWrapper wrapper = new InvWrapper((IInventory)shelf);
            if (!player.func_70093_af()) {
                ItemStack result;
                if (heldItem != null && ((result = wrapper.insertItem(slot, heldItem, true)) == null || result.field_77994_a != heldItem.field_77994_a)) {
                    if (!world.field_72995_K) {
                        result = wrapper.insertItem(slot, heldItem.func_77946_l(), false);
                        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
                        if (!player.func_184812_l_()) {
                            player.func_184611_a(hand, result);
                        }
                    }
                    world.func_184133_a(null, pos, SoundEvents.field_187626_cN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            } else {
                ItemStack result = wrapper.extractItem(slot, 1, true);
                if (result != null && result.field_77994_a > 0) {
                    if (!world.field_72995_K) {
                        result = wrapper.extractItem(slot, 1, false);
                        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
                        if (!player.field_71071_by.func_70441_a(result)) {
                            player.func_70099_a(result, 0.0f);
                        }
                        world.func_184133_a(null, pos, SoundEvents.field_187626_cN, SoundCategory.BLOCKS, 1.0f, 0.8f);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityItemShelf();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

