/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityGeckoCage;

public class BlockGeckoCage
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockGeckoCage() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)rotation));
        worldIn.func_180501_a(pos, state, 3);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItemStack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.func_175625_s(pos) instanceof TileEntityGeckoCage) {
            TileEntityGeckoCage tile = (TileEntityGeckoCage)world.func_175625_s(pos);
            if (player.func_70093_af()) {
                return false;
            }
            if (heldItemStack != null) {
                Item heldItem = heldItemStack.func_77973_b();
                if (heldItem == ItemRegistry.GECKO) {
                    if (!tile.hasGecko()) {
                        tile.addGecko(12);
                        if (!player.field_71075_bZ.field_75098_d) {
                            --heldItemStack.field_77994_a;
                        }
                        return true;
                    }
                    return false;
                }
                if (tile.getAspectType() == null) {
                    if (tile.hasGecko()) {
                        if (DiscoveryContainer.hasDiscoveryProvider(player)) {
                            if (!world.field_72995_K) {
                                AspectItem aspectItem;
                                AspectManager manager = AspectManager.get(world);
                                List<Aspect> aspects = manager.getStaticAspects(aspectItem = AspectManager.getAspectItem(heldItemStack));
                                if (aspects.size() > 0) {
                                    DiscoveryContainer<?> mergedKnowledge = DiscoveryContainer.getMergedDiscoveryContainer(player);
                                    DiscoveryContainer.AspectDiscovery discovery = mergedKnowledge.discover(manager, aspectItem);
                                    switch (discovery.result) {
                                        case NEW: 
                                        case LAST: {
                                            DiscoveryContainer.addDiscoveryToContainers(player, aspectItem, discovery.discovered.type);
                                            if (!world.field_72995_K) {
                                                tile.setAspectType(discovery.discovered.type, 600);
                                                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery." + discovery.discovered.type.getName(), new Object[0]));
                                                if (discovery.result == DiscoveryContainer.AspectDiscovery.EnumDiscoveryResult.LAST) {
                                                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.last", new Object[0]));
                                                } else {
                                                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.more", new Object[0]));
                                                }
                                                if (!player.field_71075_bZ.field_75098_d) {
                                                    --heldItemStack.field_77994_a;
                                                }
                                            }
                                            return true;
                                        }
                                        case END: {
                                            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.end", new Object[0]));
                                            return false;
                                        }
                                    }
                                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.none", new Object[0]));
                                    return false;
                                }
                                return true;
                            }
                            if (!world.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.none", new Object[0]));
                            }
                            return false;
                        }
                        if (!world.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.book.none", new Object[0]));
                        }
                        return false;
                    }
                    if (!world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.gecko.none", new Object[0]));
                    }
                    return false;
                }
                if (!world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.gecko.recovering", new Object[0]));
                }
                return false;
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGeckoCage();
    }
}

