/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.recipes.ICompostBinRecipe;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.CompostRecipe;
import thebetweenlands.common.tile.TileEntityCompostBin;

public class BlockCompostBin
extends BasicBlock
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockCompostBin() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176735_f());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176735_f()), 2);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCompostBin();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        block5: {
            boolean open;
            TileEntityCompostBin tile;
            block7: {
                block8: {
                    block6: {
                        if (world.field_72995_K || !(world.func_175625_s(pos) instanceof TileEntityCompostBin)) break block5;
                        tile = (TileEntityCompostBin)world.func_175625_s(pos);
                        open = tile.isOpen();
                        if ((heldItem != null || open && !player.func_70093_af() && tile.getCompostedAmount() != 0) && (heldItem == null || open)) break block6;
                        tile.setOpen(!open);
                        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
                        tile.func_70296_d();
                        break block5;
                    }
                    if (!open || heldItem == null) break block7;
                    ICompostBinRecipe compostRecipe = CompostRecipe.getCompostRecipe(heldItem);
                    if (compostRecipe == null) break block8;
                    int amount = compostRecipe.getCompostAmount(heldItem);
                    int time = compostRecipe.getCompostingTime(heldItem);
                    switch (tile.addItemToBin(heldItem, amount, time, true)) {
                        case 1: {
                            tile.addItemToBin(heldItem, amount, time, false);
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                                break;
                            }
                            break block5;
                        }
                        default: {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.compost.full", new Object[0]));
                            break;
                        }
                    }
                    break block5;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.compost.not.compostable", new Object[0]));
                break block5;
            }
            if (tile.getCompostedAmount() > 0 && open && tile.removeCompost(25)) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, ItemMisc.EnumItemMisc.COMPOST.create(1)));
            }
        }
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

