/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.tile.TileEntityAnimator;

public class BlockAnimator
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockAnimator() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAnimator();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) instanceof TileEntityAnimator) {
            TileEntityAnimator animator = (TileEntityAnimator)world.func_175625_s(pos);
            if (animator.fuelConsumed < animator.requiredFuelCount) {
                playerIn.openGui((Object)TheBetweenlands.INSTANCE, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                IAnimatorRecipe recipe = AnimatorRecipe.getRecipe(animator.itemToAnimate);
                if (recipe == null || recipe.onRetrieved(world, pos, animator.itemToAnimate)) {
                    playerIn.openGui((Object)TheBetweenlands.INSTANCE, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                animator.fuelConsumed = 0;
            }
            animator.itemToAnimate = null;
            animator.itemAnimated = false;
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntityAnimator te = (TileEntityAnimator)worldIn.func_175625_s(pos);
        if (te != null && te.isSlotInUse(0) && te.isCrystalInslot() && te.isSulfurInslot() && te.fuelConsumed < te.requiredFuelCount && te.isValidFocalItem()) {
            int meta = te.func_145832_p();
            double xOff = 0.0;
            double zOff = 0.0;
            switch (meta) {
                case 0: {
                    xOff = -0.5;
                    zOff = 0.14f;
                    break;
                }
                case 1: {
                    xOff = -0.14f;
                    zOff = -0.5;
                    break;
                }
                case 2: {
                    xOff = 0.5;
                    zOff = -0.14f;
                    break;
                }
                case 3: {
                    xOff = 0.14f;
                    zOff = 0.5;
                }
            }
            ArrayList<Vec3d> points = new ArrayList<Vec3d>();
            points.add(new Vec3d((double)te.func_174877_v().func_177958_n() + 0.5 + (double)(rand.nextFloat() - 0.5f) * 0.3 + xOff, (double)te.func_174877_v().func_177956_o() + 0.9, (double)te.func_174877_v().func_177952_p() + 0.5 + (double)(rand.nextFloat() - 0.5f) * 0.3 + zOff));
            points.add(new Vec3d((double)te.func_174877_v().func_177958_n() + 0.5 + (double)(rand.nextFloat() - 0.5f) * 0.3 + xOff, (double)te.func_174877_v().func_177956_o() + 1.36, (double)te.func_174877_v().func_177952_p() + 0.5 + (double)(rand.nextFloat() - 0.5f) * 0.3 + zOff));
            points.add(new Vec3d((double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 1.45, (double)te.func_174877_v().func_177952_p() + 0.5));
            BLParticles.ANIMATOR.spawn(worldIn, te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o() + 0.9, (double)te.func_174877_v().func_177952_p() + 0.65, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(points));
            BLParticles.SMOKE.spawn(worldIn, (double)te.func_174877_v().func_177958_n() + 0.5 + (double)rand.nextFloat() * 0.3 - 0.15, (double)te.func_174877_v().func_177956_o() + 0.3, (double)te.func_174877_v().func_177952_p() + 0.5 + (double)rand.nextFloat() * 0.3 - 0.15);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }
}

