/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common;

import net.minecraft.command.ICommand;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import thebetweenlands.common.BetweenlandsAPI;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.capability.base.EntityCapabilityHandler;
import thebetweenlands.common.capability.base.ItemCapabilityHandler;
import thebetweenlands.common.command.CommandAspectDiscovery;
import thebetweenlands.common.command.CommandBLEvent;
import thebetweenlands.common.command.CommandReloadRecipes;
import thebetweenlands.common.command.CommandResetAspects;
import thebetweenlands.common.handler.AnvilEventHandler;
import thebetweenlands.common.handler.ArmorHandler;
import thebetweenlands.common.handler.AspectSyncHandler;
import thebetweenlands.common.handler.AttackDamageHandler;
import thebetweenlands.common.handler.BlockBreakHandler;
import thebetweenlands.common.handler.EntitySpawnHandler;
import thebetweenlands.common.handler.EnvironmentEventHandler;
import thebetweenlands.common.handler.FoodSicknessHandler;
import thebetweenlands.common.handler.ItemEquipmentHandler;
import thebetweenlands.common.handler.LocationHandler;
import thebetweenlands.common.handler.OverworldItemHandler;
import thebetweenlands.common.handler.PlayerDecayHandler;
import thebetweenlands.common.handler.PlayerPortalHandler;
import thebetweenlands.common.handler.PuppetHandler;
import thebetweenlands.common.item.equipment.ItemRingOfFlight;
import thebetweenlands.common.item.tools.ItemBLShield;
import thebetweenlands.common.proxy.CommonProxy;
import thebetweenlands.common.registries.MessageRegistry;
import thebetweenlands.common.registries.Registries;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.biome.spawning.MobSpawnHandler;
import thebetweenlands.common.world.gen.feature.structure.WorldGenDruidCircle;
import thebetweenlands.common.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.common.world.storage.chunk.ChunkDataBase;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;
import thebetweenlands.core.TheBetweenlandsPreconditions;
import thebetweenlands.util.config.ConfigHandler;

@Mod(modid="thebetweenlands", name="The Betweenlands", version="2.0.4-alpha", guiFactory="thebetweenlands.util.config.ConfigGuiFactory", acceptedMinecraftVersions="1.10.2")
public class TheBetweenlands {
    @Mod.Instance(value="thebetweenlands")
    public static TheBetweenlands INSTANCE;
    @SidedProxy(modId="thebetweenlands", clientSide="thebetweenlands.client.proxy.ClientProxy", serverSide="thebetweenlands.common.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Registries REGISTRIES;
    public static DimensionType dimensionType;
    public static SimpleNetworkWrapper networkWrapper;
    public static Logger logger;
    public static boolean isToughAsNailsModInstalled;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigHandler.INSTANCE.loadConfig(event);
        BetweenlandsAPI.init();
        dimensionType = DimensionType.register((String)"Betweenlands", (String)"", (int)ConfigHandler.dimensionId, WorldProviderBetweenlands.class, (boolean)false);
        DimensionManager.registerDimension((int)ConfigHandler.dimensionId, (DimensionType)dimensionType);
        REGISTRIES.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)proxy);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("thebetweenlands");
        MessageRegistry.preInit();
        proxy.registerItemAndBlockRenderers();
        proxy.preInit();
    }

    @Mod.InstanceFactory
    public static TheBetweenlands createInstance() {
        TheBetweenlandsPreconditions.check();
        return new TheBetweenlands();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        REGISTRIES.init();
        proxy.init();
        this.registerEventHandlers();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenDruidCircle(), (int)0);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        isToughAsNailsModInstalled = Loader.isModLoaded((String)"toughasnails") || Loader.isModLoaded((String)"ToughAsNails");
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBLEvent());
        event.registerServerCommand((ICommand)new CommandResetAspects());
        event.registerServerCommand((ICommand)new CommandAspectDiscovery());
        event.registerServerCommand((ICommand)new CommandReloadRecipes());
    }

    private void registerEventHandlers() {
        proxy.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)ConfigHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ItemBLShield.EventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)WorldDataBase.WORLD_EVENT_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)ChunkDataBase.CHUNK_EVENT_HANDLER);
        MinecraftForge.EVENT_BUS.register(BetweenlandsChunkData.class);
        MinecraftForge.EVENT_BUS.register((Object)new AnvilEventHandler());
        MinecraftForge.EVENT_BUS.register(EnvironmentEventHandler.class);
        MinecraftForge.EVENT_BUS.register(EntityCapabilityHandler.class);
        MinecraftForge.EVENT_BUS.register(ItemCapabilityHandler.class);
        MinecraftForge.EVENT_BUS.register(PlayerDecayHandler.class);
        MinecraftForge.EVENT_BUS.register(AspectSyncHandler.class);
        MinecraftForge.EVENT_BUS.register((Object)MobSpawnHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register(BlockBreakHandler.class);
        MinecraftForge.EVENT_BUS.register(LocationHandler.class);
        MinecraftForge.EVENT_BUS.register(AttackDamageHandler.class);
        MinecraftForge.EVENT_BUS.register(ItemEquipmentHandler.class);
        MinecraftForge.EVENT_BUS.register(EntitySpawnHandler.class);
        MinecraftForge.EVENT_BUS.register(ArmorHandler.class);
        MinecraftForge.EVENT_BUS.register(ItemRingOfFlight.class);
        MinecraftForge.EVENT_BUS.register(PuppetHandler.class);
        MinecraftForge.EVENT_BUS.register(OverworldItemHandler.class);
        MinecraftForge.EVENT_BUS.register(PlayerPortalHandler.class);
        MinecraftForge.EVENT_BUS.register(FoodSicknessHandler.class);
        MinecraftForge.EVENT_BUS.register(BlockGenericDugSoil.class);
    }

    static {
        REGISTRIES = new Registries();
        isToughAsNailsModInstalled = false;
    }
}

