/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.handler.WorldRenderHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleWisp;
import thebetweenlands.common.block.terrain.BlockWisp;
import thebetweenlands.common.tile.TileEntityWisp;
import thebetweenlands.util.TileEntityHelper;
import thebetweenlands.util.config.ConfigHandler;

public class RenderWisp
extends TileEntitySpecialRenderer<TileEntityWisp> {
    public void renderTileEntityAt(TileEntityWisp tileEntity, double x, double y, double z, float partialTicks, int destroyProgress) {
        WorldRenderHandler.WISP_TILE_LIST.add((Pair<Pair<RenderWisp, TileEntityWisp>, Vec3d>)Pair.of((Object)Pair.of((Object)((Object)this), (Object)((Object)tileEntity)), (Object)new Vec3d(x, y, z)));
        List<Object> particleList = tileEntity.particleList;
        double renderViewX = Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double renderViewY = Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double renderViewZ = Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (!BlockWisp.canSee(tileEntity.func_145831_w(), tileEntity.func_174877_v())) {
            double dist;
            double d = dist = renderView != null ? renderView.func_70011_f(x + renderViewX, y + renderViewY, z + renderViewZ) : 0.0;
            if (dist > 50.0 || dist < 10.0) {
                return;
            }
        }
        if (particleList.size() < 1000 && !Minecraft.func_71410_x().func_147113_T() && (float)(System.nanoTime() - tileEntity.lastSpawn) >= (500.0f - 500.0f * (float)ConfigHandler.wispQuality / 150.0f) * 1000000.0f) {
            tileEntity.lastSpawn = System.nanoTime();
            int colorIndex = TileEntityHelper.getStatePropertySafely(tileEntity, BlockWisp.class, BlockWisp.COLOR, 0);
            int color = BlockWisp.COLORS[colorIndex * 2];
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            particleList.add(BLParticles.WISP.create(tileEntity.func_145831_w(), x + 0.5 + renderViewX, y + 0.5 + renderViewY, z + 0.5 + renderViewZ, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withColor(r, g, b, 1.0f)).withScale(3.0f)));
            color = BlockWisp.COLORS[colorIndex * 2 + 1];
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
            particleList.add(BLParticles.WISP.create(tileEntity.func_145831_w(), x + 0.5 + renderViewX, y + 0.5 + renderViewY, z + 0.5 + renderViewZ, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withColor(r, g, b, 1.0f)).withScale(2.0f)));
        }
    }

    public void renderWispParticles(VertexBuffer vertexBuffer, TileEntityWisp tileEntity, double x, double y, double z, float partialTicks) {
        List<Object> particleList = tileEntity.particleList;
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        if (viewer != null) {
            Particle.field_70556_an = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
            Particle.field_70554_ao = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
            Particle.field_70555_ap = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
            Particle.field_190016_K = viewer.func_70676_i(partialTicks);
            for (Object particle : particleList) {
                ParticleWisp wisp = (ParticleWisp)particle;
                wisp.func_180434_a(vertexBuffer, viewer, partialTicks, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178809_c(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f());
            }
        }
    }
}

