/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.model.tile.ModelLootPot1;
import thebetweenlands.client.render.model.tile.ModelLootPot2;
import thebetweenlands.client.render.model.tile.ModelLootPot3;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.util.TileEntityHelper;

public class RenderLootPot
extends TileEntitySpecialRenderer<TileEntityLootPot> {
    private static final ModelLootPot1 LOOT_POT = new ModelLootPot1();
    private static final ModelLootPot2 LOOT_POT_2 = new ModelLootPot2();
    private static final ModelLootPot3 LOOT_POT_3 = new ModelLootPot3();
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("thebetweenlands:textures/tiles/loot_pot_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("thebetweenlands:textures/tiles/loot_pot_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("thebetweenlands:textures/tiles/loot_pot_3.png");

    public void renderTileEntityAt(TileEntityLootPot te, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockLootPot.EnumLootPot type = TileEntityHelper.getStatePropertySafely(te, BlockLootPot.class, BlockLootPot.VARIANT, BlockLootPot.EnumLootPot.POT_1);
        EnumFacing rotation = TileEntityHelper.getStatePropertySafely(te, BlockLootPot.class, BlockLootPot.FACING, EnumFacing.NORTH);
        int offset = te.getModelRotationOffset();
        switch (type) {
            default: {
                this.func_147499_a(TEXTURE_1);
                break;
            }
            case POT_2: {
                this.func_147499_a(TEXTURE_2);
                break;
            }
            case POT_3: {
                this.func_147499_a(TEXTURE_3);
            }
        }
        switch (rotation) {
            default: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)offset, (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
                break;
            }
            case EAST: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)((float)offset + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
                break;
            }
            case SOUTH: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)((float)offset + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
                break;
            }
            case WEST: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)((float)offset + 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderType(BlockLootPot.EnumLootPot type) {
        switch (type) {
            case POT_1: {
                LOOT_POT.render();
                break;
            }
            case POT_2: {
                LOOT_POT_2.render();
                break;
            }
            case POT_3: {
                LOOT_POT_3.render();
            }
        }
    }
}

