/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.client.render.model.tile.ModelGeckoCage;
import thebetweenlands.client.render.model.tile.ModelGeckoCorrupted;
import thebetweenlands.client.render.model.tile.ModelGeckoGreen;
import thebetweenlands.client.render.model.tile.ModelGeckoNormal;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.tile.TileEntityGeckoCage;

public class RenderGeckoCage
extends TileEntitySpecialRenderer<TileEntityGeckoCage> {
    private static final ModelGeckoCage MODEL = new ModelGeckoCage();
    private static final ModelGeckoNormal MODEL_GECKO_NORMAL = new ModelGeckoNormal();
    private static final ModelGeckoCorrupted MODEL_GECKO_CORRUPTED = new ModelGeckoCorrupted();
    private static final ModelGeckoGreen MODEL_GECKO_GREEN = new ModelGeckoGreen();
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/gecko_cage.png");
    private static final ResourceLocation GECKO_TEXTURE_NORMAL = new ResourceLocation("thebetweenlands:textures/entity/gecko.png");
    private static final ResourceLocation GECKO_TEXTURE_CORRUPTED = new ResourceLocation("thebetweenlands:textures/entity/gecko_corrupted.png");
    private static final ResourceLocation GECKO_TEXTURE_GREEN = new ResourceLocation("thebetweenlands:textures/entity/gecko_green.png");
    private static final ResourceLocation GECKO_TEXTURE_PALE = new ResourceLocation("thebetweenlands:textures/entity/gecko_pale.png");
    private static final ResourceLocation GECKO_TEXTURE_RED = new ResourceLocation("thebetweenlands:textures/entity/gecko_red.png");
    private static final ResourceLocation GECKO_TEXTURE_TAN = new ResourceLocation("thebetweenlands:textures/entity/gecko_tan.png");

    public void renderTileEntityAt(TileEntityGeckoCage cage, double x, double y, double z, float partialTickTime, int destroyProgress) {
        int meta = cage != null ? cage.func_145832_p() : 0;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (meta) {
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.func_147499_a(TEXTURE);
        GL11.glDisable((int)2884);
        MODEL.render();
        GL11.glEnable((int)2884);
        if (cage != null && cage.hasGecko()) {
            GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
            GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            float speed = 0.0f;
            float swing = 0.0f;
            IAspectType aspect = cage.getAspectType();
            if (aspect == AspectRegistry.FERGALAZ) {
                this.func_147499_a(GECKO_TEXTURE_TAN);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTickTime, swing, speed);
            } else if (aspect == AspectRegistry.FIRNALAZ) {
                this.func_147499_a(GECKO_TEXTURE_RED);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTickTime, swing, speed);
            } else if (aspect == AspectRegistry.GEOLIIRGAZ) {
                this.func_147499_a(GECKO_TEXTURE_PALE);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTickTime, swing, speed);
            } else if (aspect == AspectRegistry.YIHINREN) {
                this.func_147499_a(GECKO_TEXTURE_GREEN);
                MODEL_GECKO_GREEN.render(cage.getTicks(), partialTickTime, swing, speed);
            } else if (aspect == AspectRegistry.BYARIIS) {
                this.func_147499_a(GECKO_TEXTURE_CORRUPTED);
                MODEL_GECKO_CORRUPTED.render(cage.getTicks(), partialTickTime);
            } else {
                this.func_147499_a(GECKO_TEXTURE_NORMAL);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTickTime, swing, speed);
            }
        }
        GL11.glPopMatrix();
    }
}

