/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.model.tile.ModelDruidAltar;
import thebetweenlands.client.render.model.tile.ModelStone;
import thebetweenlands.common.block.container.BlockDruidAltar;
import thebetweenlands.common.tile.TileEntityDruidAltar;
import thebetweenlands.util.LightingUtil;
import thebetweenlands.util.TileEntityHelper;

@SideOnly(value=Side.CLIENT)
public class RenderDruidAltar
extends TileEntitySpecialRenderer<TileEntityDruidAltar> {
    public static RenderDruidAltar instance;
    private final ModelDruidAltar model = new ModelDruidAltar();
    private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    private final ModelStone stone = new ModelStone();
    private final ResourceLocation ACTIVE = new ResourceLocation("thebetweenlands:textures/tiles/druid_altar_active.png");
    private final ResourceLocation ACTIVEGLOW = new ResourceLocation("thebetweenlands:textures/tiles/druid_altar_active_glow.png");
    private final ResourceLocation NORMAL = new ResourceLocation("thebetweenlands:textures/tiles/druid_altar.png");
    private final ResourceLocation NORMALGLOW = new ResourceLocation("thebetweenlands:textures/tiles/druid_altar_glow.png");

    public void func_147497_a(TileEntityRendererDispatcher renderer) {
        super.func_147497_a(renderer);
        instance = this;
    }

    public void renderTileAsItem(double x, double y, double z) {
        this.func_147499_a(this.NORMAL);
        GlStateManager.func_179094_E();
        this.renderMainModel(x, y, z);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.renderStones(x, y, z, 0.0f);
        GlStateManager.func_179121_F();
        LightingUtil.INSTANCE.setLighting(255);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179132_a((boolean)true);
        this.func_147499_a(this.NORMALGLOW);
        GlStateManager.func_179094_E();
        this.renderMainModel(x, y, z);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.renderStones(x, y, z, 0.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        LightingUtil.INSTANCE.revert();
    }

    private void renderTile(TileEntityDruidAltar tile, double x, double y, double z, float partialTicks) {
        if (tile.func_145832_p() == 1) {
            this.func_147499_a(this.ACTIVE);
        } else {
            this.func_147499_a(this.NORMAL);
        }
        GlStateManager.func_179094_E();
        this.renderMainModel(x, y, z);
        GlStateManager.func_179121_F();
        float renderRotation = tile.rotation + (tile.rotation - tile.prevRotation) * partialTicks;
        GlStateManager.func_179094_E();
        this.renderStones(x, y, z, renderRotation);
        GlStateManager.func_179121_F();
        LightingUtil.INSTANCE.setLighting(255);
        double yOff = 1.2;
        if (TileEntityHelper.getStatePropertySafely(tile, BlockDruidAltar.class, BlockDruidAltar.ACTIVE, false).booleanValue() && tile.craftingProgress != 0) {
            yOff = Math.min((double)(tile.renderYOffset + (tile.renderYOffset - tile.prevRenderYOffset) * partialTicks), 3.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 3.1), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)(renderRotation * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            double shineScale = (double)0.04f * Math.pow(1.0 - (3.0 - yOff) / 2.0, 12.0);
            GlStateManager.func_179139_a((double)shineScale, (double)shineScale, (double)shineScale);
            this.renderShine((float)Math.sin(Math.toRadians(renderRotation)) / 2.0f - 0.2f, (int)(80.0 * Math.pow(1.0 - (3.0 - yOff) / 2.0, 12.0)));
            GlStateManager.func_179121_F();
        }
        for (int xi = 0; xi < 2; ++xi) {
            for (int zi = 0; zi < 2; ++zi) {
                ItemStack item = tile.func_70301_a(zi * 2 + xi + 1);
                if (item == null) continue;
                float xOff = xi == 0 ? -0.18f : 1.18f;
                float zOff = zi == 0 ? -0.18f : 1.18f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + (double)xOff), (double)(y + 1.0), (double)(z + (double)zOff));
                this.renderCone(5);
                GlStateManager.func_179121_F();
                Vector3d midVec = new Vector3d();
                midVec.field_181059_a = (float)x + 0.5f;
                midVec.field_181061_c = (float)z + 0.5f;
                Vector3d diffVec = new Vector3d();
                diffVec.field_181059_a = (double)((float)x + xOff) - midVec.field_181059_a;
                diffVec.field_181061_c = (double)((float)z + zOff) - midVec.field_181061_c;
                double rProgress = 1.0 - Math.pow(1.0 - (3.0 - yOff) / 2.0, 6.0);
                diffVec.field_181059_a *= rProgress;
                diffVec.field_181061_c *= rProgress;
                midVec.field_181059_a += diffVec.field_181059_a;
                midVec.field_181061_c += diffVec.field_181061_c;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)midVec.field_181059_a, (double)(y + yOff), (double)midVec.field_181061_c);
                GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
                GlStateManager.func_179114_b((float)(-renderRotation * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderItem(item);
                GlStateManager.func_179121_F();
            }
        }
        ItemStack itemTalisman = tile.func_70301_a(0);
        if (itemTalisman != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 3.1), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)(renderRotation * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            double shineScale = 0.04f;
            GlStateManager.func_179139_a((double)shineScale, (double)shineScale, (double)shineScale);
            this.renderShine((float)Math.sin(Math.toRadians(renderRotation)) / 2.0f - 0.2f, 80);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 3.1), (double)(z + 0.5));
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
            GlStateManager.func_179114_b((float)(-renderRotation * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderItem(itemTalisman);
            GlStateManager.func_179121_F();
        }
        LightingUtil.INSTANCE.revert();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179132_a((boolean)true);
        float lighting = 150.0f;
        if (tile.func_145832_p() == 1) {
            lighting = (float)Math.sin(Math.toRadians(renderRotation) * 4.0) * 105.0f + 150.0f;
        }
        LightingUtil.INSTANCE.setLighting((int)lighting);
        if (tile.func_145832_p() == 1) {
            this.func_147499_a(this.ACTIVEGLOW);
        } else {
            this.func_147499_a(this.NORMALGLOW);
        }
        GlStateManager.func_179094_E();
        this.renderMainModel(x, y, z);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.renderStones(x, y, z, renderRotation);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        LightingUtil.INSTANCE.revert();
    }

    private void renderMainModel(double x, double y, double z) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.renderAll(0.0625f);
        GlStateManager.func_179121_F();
    }

    private void renderStones(double x, double y, double z, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.stone.renderAll();
        GlStateManager.func_179121_F();
    }

    private void renderShine(float rotation, int iterations) {
        Random random = new Random(432L);
        GlStateManager.func_179090_x();
        GL11.glShadeModel((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        float f1 = rotation;
        float f2 = 0.0f;
        if (f1 > 0.8f) {
            f2 = (f1 - 0.8f) / 0.2f;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        int i = 0;
        while ((float)i < (float)iterations) {
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f + f1 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            float pos1 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float pos2 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 255, 255, (int)(255.0f * (1.0f - f2))).func_181675_d();
            buffer.func_181662_b(-0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2)).func_181669_b(0, 0, 255, 0).func_181675_d();
            buffer.func_181662_b(0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2)).func_181669_b(0, 0, 255, 0).func_181675_d();
            buffer.func_181662_b(0.0, (double)pos1, (double)(1.0f * pos2)).func_181669_b(0, 0, 255, 0).func_181675_d();
            buffer.func_181662_b(-0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2)).func_181669_b(0, 0, 255, 0).func_181675_d();
            tessellator.func_78381_a();
            ++i;
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GL11.glShadeModel((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
    }

    private void renderCone(int faces) {
        GlStateManager.func_179094_E();
        float step = 360.0f / (float)faces;
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        for (float i = 0.0f; i < 360.0f; i += step) {
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            double lr = 0.1;
            double ur = 0.3;
            double height = 0.2;
            double sin = Math.sin(Math.toRadians(i));
            double cos = Math.cos(Math.toRadians(i));
            double sin2 = Math.sin(Math.toRadians(i + step));
            double cos2 = Math.cos(Math.toRadians(i + step));
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(sin * lr, 0.0, cos * lr).func_181669_b(255, 255, 255, 0).func_181675_d();
            buffer.func_181662_b(sin2 * lr, 0.0, cos2 * lr).func_181669_b(255, 255, 255, 0).func_181675_d();
            buffer.func_181662_b(sin2 * ur, height, cos2 * ur).func_181669_b(0, 0, 255, 60).func_181675_d();
            buffer.func_181662_b(sin * ur, height, cos * ur).func_181669_b(0, 0, 255, 60).func_181675_d();
            buffer.func_181662_b(sin * ur, height, cos * ur).func_181669_b(0, 0, 255, 60).func_181675_d();
            buffer.func_181662_b(sin2 * ur, height, cos2 * ur).func_181669_b(0, 0, 255, 60).func_181675_d();
            buffer.func_181662_b(sin2 * lr, 0.0, cos2 * lr).func_181669_b(255, 255, 255, 0).func_181675_d();
            buffer.func_181662_b(sin * lr, 0.0, cos * lr).func_181669_b(255, 255, 255, 0).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    public void renderTileEntityAt(TileEntityDruidAltar te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (te == null || !te.func_145830_o()) {
            this.renderTileAsItem(x, y, z);
            return;
        }
        this.renderTile(te, x, y, z, partialTicks);
    }

    private void renderItem(ItemStack stack) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        RenderHelper.func_74518_a();
        this.renderItem.func_180454_a(stack, this.renderItem.func_175037_a().func_178089_a(stack));
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }
}

