/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sprite;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import thebetweenlands.client.handler.TextureStitchHandler;

public class TextureAnimation {
    private TextureStitchHandler.Frame[] frames;
    private int frameTicks = 0;
    private int frameCounter = 0;
    private int totalDuration = 0;
    private Random rand;

    public int getTotalDuration() {
        return this.totalDuration;
    }

    public TextureAnimation setRandomStart(@Nullable Random random) {
        this.rand = random;
        return this;
    }

    public void update() {
        ++this.frameTicks;
        if (this.frameTicks >= this.getCurrentFrame().getDuration()) {
            this.frameCounter = (this.frameCounter + 1) % this.frames.length;
            this.frameTicks = 0;
        }
    }

    public void setFrameCounter(int counter) {
        this.frameCounter = counter % this.frames.length;
    }

    public int getFrameCounter() {
        return this.frameCounter;
    }

    public TextureStitchHandler.Frame getCurrentFrame() {
        return this.frames[this.frameCounter];
    }

    public TextureAtlasSprite getCurrentSprite() {
        return this.getCurrentFrame().getSprite();
    }

    public TextureAnimation setFrames(TextureStitchHandler.Frame[] frames) {
        boolean setRandom = this.rand != null && this.frames == null;
        this.frames = frames;
        if (setRandom) {
            this.frameCounter = this.rand.nextInt(this.frames.length);
        } else if (this.frameCounter >= this.frames.length) {
            this.frameCounter = 0;
        }
        this.totalDuration = 0;
        for (TextureStitchHandler.Frame frame : frames) {
            this.totalDuration += frame.getDuration();
        }
        return this;
    }
}

