/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader.postprocessing;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.shader.DepthBuffer;
import thebetweenlands.client.render.shader.GeometryBuffer;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ResizableFramebuffer;
import thebetweenlands.client.render.shader.postprocessing.GodRay;
import thebetweenlands.client.render.shader.postprocessing.OcclusionExtractor;
import thebetweenlands.client.render.shader.postprocessing.PostProcessingEffect;
import thebetweenlands.client.render.shader.postprocessing.Starfield;
import thebetweenlands.client.render.shader.postprocessing.Swirl;
import thebetweenlands.client.render.shader.postprocessing.Warp;
import thebetweenlands.client.render.sky.BLSkyRenderer;
import thebetweenlands.common.entity.mobs.EntityGasCloud;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.util.GLUProjection;
import thebetweenlands.util.config.ConfigHandler;

public class WorldShader
extends PostProcessingEffect<WorldShader> {
    private DepthBuffer depthBuffer;
    private ResizableFramebuffer blitBuffer;
    private ResizableFramebuffer occlusionBuffer;
    private GeometryBuffer repellerShieldBuffer;
    private GeometryBuffer gasParticlesBuffer;
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private Matrix4f invertedModelviewProjectionMatrix;
    private Matrix4f modelviewProjectionMatrix;
    private Matrix4f modelviewMatrix;
    private Matrix4f projectionMatrix;
    public static final int MAX_LIGHT_SOURCES_PER_PASS = 32;
    private List<LightSource> lightSources = new ArrayList<LightSource>();
    private int depthUniformID = -1;
    private int repellerDiffuseUniformID = -1;
    private int repellerDepthUniformID = -1;
    private int gasParticlesDiffuseUniformID = -1;
    private int gasParticlesDepthUniformID = -1;
    private int invMVPUniformID = -1;
    private int fogModeUniformID = -1;
    private int[] lightSourcePositionUniformIDs = new int[32];
    private int[] lightSourceColorUniformIDs = new int[32];
    private int[] lightSourceRadiusUniformIDs = new int[32];
    private int lightSourceAmountUniformID = -1;
    private int msTimeUniformID = -1;
    private int worldTimeUniformID = -1;
    private int camPosUniformID = -1;
    private Framebuffer gasTextureBaseFramebuffer = null;
    private Framebuffer gasTextureFramebuffer = null;
    private Framebuffer starfieldTextureFramebuffer = null;
    private Warp gasWarpEffect = null;
    private Starfield starfieldEffect = null;
    private OcclusionExtractor occlusionExtractor = null;
    private GodRay godRayEffect = null;
    private Swirl swirlEffect = null;
    private float swirlAngle = 0.0f;
    private float lastSwirlAngle = 0.0f;
    private int currentRenderPass = 0;
    private static final Comparator<LightSource> LIGHT_SOURCE_SORTER = new Comparator<LightSource>(){

        @Override
        public int compare(LightSource o1, LightSource o2) {
            double d2;
            double dx1 = o1.x - Minecraft.func_71410_x().func_175598_ae().field_78730_l;
            double dy1 = o1.y - Minecraft.func_71410_x().func_175598_ae().field_78731_m;
            double dz1 = o1.z - Minecraft.func_71410_x().func_175598_ae().field_78728_n;
            double dx2 = o2.x - Minecraft.func_71410_x().func_175598_ae().field_78730_l;
            double dy2 = o2.y - Minecraft.func_71410_x().func_175598_ae().field_78731_m;
            double dz2 = o2.z - Minecraft.func_71410_x().func_175598_ae().field_78728_n;
            double d1 = Math.sqrt(dx1 * dx1 + dy1 * dy1 + dz1 * dz1);
            if (d1 > (d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2))) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return 0;
        }
    };

    @Override
    protected ResourceLocation[] getShaders() {
        return new ResourceLocation[]{new ResourceLocation("thebetweenlands:shaders/postprocessing/world/world.vsh"), new ResourceLocation("thebetweenlands:shaders/postprocessing/world/world.fsh")};
    }

    @Override
    protected void deleteEffect() {
        if (this.depthBuffer != null) {
            this.depthBuffer.deleteBuffer();
        }
        if (this.blitBuffer != null) {
            this.blitBuffer.delete();
        }
        if (this.occlusionBuffer != null) {
            this.occlusionBuffer.delete();
        }
        if (this.repellerShieldBuffer != null) {
            this.repellerShieldBuffer.deleteBuffers();
        }
        if (this.gasParticlesBuffer != null) {
            this.gasParticlesBuffer.deleteBuffers();
        }
        if (this.gasTextureBaseFramebuffer != null) {
            this.gasTextureBaseFramebuffer.func_147608_a();
        }
        if (this.gasTextureFramebuffer != null) {
            this.gasTextureFramebuffer.func_147608_a();
        }
        if (this.starfieldTextureFramebuffer != null) {
            this.starfieldTextureFramebuffer.func_147608_a();
        }
        if (this.gasWarpEffect != null) {
            this.gasWarpEffect.delete();
        }
        if (this.starfieldEffect != null) {
            this.starfieldEffect.delete();
        }
        if (this.occlusionExtractor != null) {
            this.occlusionExtractor.delete();
        }
        if (this.godRayEffect != null) {
            this.godRayEffect.delete();
        }
    }

    @Override
    protected boolean initEffect() {
        int i;
        this.depthUniformID = this.getUniform("s_diffuse_depth");
        this.repellerDiffuseUniformID = this.getUniform("s_repellerShield");
        this.repellerDepthUniformID = this.getUniform("s_repellerShield_depth");
        this.gasParticlesDiffuseUniformID = this.getUniform("s_gasParticles");
        this.gasParticlesDepthUniformID = this.getUniform("s_gasParticles_depth");
        this.invMVPUniformID = this.getUniform("u_INVMVP");
        this.fogModeUniformID = this.getUniform("u_fogMode");
        this.msTimeUniformID = this.getUniform("u_msTime");
        this.worldTimeUniformID = this.getUniform("u_worldTime");
        this.camPosUniformID = this.getUniform("u_camPos");
        for (i = 0; i < 32; ++i) {
            this.lightSourcePositionUniformIDs[i] = this.getUniform("u_lightSources[" + i + "].position");
        }
        for (i = 0; i < 32; ++i) {
            this.lightSourceColorUniformIDs[i] = this.getUniform("u_lightSources[" + i + "].color");
        }
        for (i = 0; i < 32; ++i) {
            this.lightSourceRadiusUniformIDs[i] = this.getUniform("u_lightSources[" + i + "].radius");
        }
        this.lightSourceAmountUniformID = this.getUniform("u_lightSourcesAmount");
        this.depthBuffer = new DepthBuffer();
        this.blitBuffer = new ResizableFramebuffer(false);
        this.occlusionBuffer = new ResizableFramebuffer(false);
        this.repellerShieldBuffer = new GeometryBuffer(true);
        this.gasParticlesBuffer = new GeometryBuffer(true);
        this.gasTextureFramebuffer = new Framebuffer(64, 64, false);
        this.gasTextureBaseFramebuffer = new Framebuffer(64, 64, false);
        this.gasWarpEffect = (Warp)new Warp().setTimeScale(4.0E-5f).setScale(40.0f).setMultiplier(3.55f).init();
        this.starfieldTextureFramebuffer = new Framebuffer(ConfigHandler.skyResolution, ConfigHandler.skyResolution, false);
        this.starfieldEffect = (Starfield)new Starfield(true).init();
        this.occlusionExtractor = (OcclusionExtractor)new OcclusionExtractor().init();
        this.godRayEffect = (GodRay)new GodRay().init();
        this.swirlEffect = (Swirl)new Swirl().init();
        return true;
    }

    @Override
    protected void uploadUniforms(float partialTicks) {
        this.uploadSampler(this.depthUniformID, this.depthBuffer.getTexture(), 1);
        this.uploadSampler(this.repellerDiffuseUniformID, this.repellerShieldBuffer.getDiffuseTexture(), 2);
        this.uploadSampler(this.repellerDepthUniformID, this.repellerShieldBuffer.getDepthTexture(), 3);
        this.uploadSampler(this.gasParticlesDiffuseUniformID, this.gasParticlesBuffer.getDiffuseTexture(), 4);
        this.uploadSampler(this.gasParticlesDepthUniformID, this.gasParticlesBuffer.getDepthTexture(), 5);
        this.uploadMatrix4f(this.invMVPUniformID, this.invertedModelviewProjectionMatrix);
        this.uploadInt(this.fogModeUniformID, FogHandler.getCurrentFogMode());
        Collections.sort(this.lightSources, LIGHT_SOURCE_SORTER);
        int renderedLightSources = Math.min(32, this.lightSources.size() - this.currentRenderPass * 32);
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        for (int i = 0; i < renderedLightSources; ++i) {
            LightSource lightSource = this.lightSources.get(this.currentRenderPass * 32 + i);
            this.uploadFloat(this.lightSourcePositionUniformIDs[i], (float)(lightSource.x - renderPosX), (float)(lightSource.y - renderPosY), (float)(lightSource.z - renderPosZ));
            this.uploadFloat(this.lightSourceColorUniformIDs[i], lightSource.r, lightSource.g, lightSource.b);
            this.uploadFloat(this.lightSourceRadiusUniformIDs[i], lightSource.radius);
        }
        this.uploadInt(this.lightSourceAmountUniformID, renderedLightSources);
        this.uploadFloat(this.msTimeUniformID, (float)System.nanoTime() / 1000000.0f);
        this.uploadFloat(this.worldTimeUniformID, (float)Minecraft.func_71410_x().field_71441_e.func_72820_D() + partialTicks);
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        Vec3d camPos = renderView != null ? ActiveRenderInfo.func_178806_a((Entity)Minecraft.func_71410_x().func_175606_aa(), (double)partialTicks) : Vec3d.field_186680_a;
        this.uploadFloat(this.camPosUniformID, (float)camPos.field_72450_a, (float)camPos.field_72448_b, (float)camPos.field_72449_c);
    }

    public void updateDepthBuffer() {
        this.depthBuffer.blitDepthBuffer(this.getMainFramebuffer());
        this.getMainFramebuffer().func_147610_a(false);
        GlStateManager.func_179144_i((int)0);
    }

    protected final Framebuffer getMainFramebuffer() {
        return Minecraft.func_71410_x().func_147110_a();
    }

    public DepthBuffer getDepthBuffer() {
        return this.depthBuffer;
    }

    public void updateMatrices() {
        Matrix4f projectionMatrix;
        Matrix4f modelviewMatrix;
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION);
        this.modelviewMatrix = modelviewMatrix = (Matrix4f)new Matrix4f().load(MODELVIEW.asReadOnlyBuffer());
        this.projectionMatrix = projectionMatrix = (Matrix4f)new Matrix4f().load(PROJECTION.asReadOnlyBuffer());
        Matrix4f MVP = new Matrix4f();
        Matrix4f.mul((Matrix4f)projectionMatrix, (Matrix4f)modelviewMatrix, (Matrix4f)MVP);
        this.modelviewProjectionMatrix = MVP;
        this.invertedModelviewProjectionMatrix = Matrix4f.invert((Matrix4f)MVP, (Matrix4f)new Matrix4f());
    }

    public Matrix4f getInvertedModelviewProjectionMatrix() {
        return this.invertedModelviewProjectionMatrix;
    }

    public Matrix4f getModelviewProjectionMatrix() {
        return this.modelviewProjectionMatrix;
    }

    public Matrix4f getModelviewMatrix() {
        return this.modelviewMatrix;
    }

    public FloatBuffer getModelviewBuffer() {
        return MODELVIEW;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public FloatBuffer getProjectionBuffer() {
        return PROJECTION;
    }

    public GeometryBuffer getGasParticleBuffer() {
        return this.gasParticlesBuffer;
    }

    public void addLight(LightSource light) {
        this.lightSources.add(light);
    }

    public void clearLights() {
        this.lightSources.clear();
    }

    public int getLightSourcesAmount() {
        return this.lightSources.size();
    }

    public void setRenderPass(int pass) {
        this.currentRenderPass = pass;
    }

    public int getGasTexture() {
        return this.gasTextureFramebuffer != null ? this.gasTextureFramebuffer.field_147617_g : -1;
    }

    public int getStarfieldTexture() {
        return this.starfieldTextureFramebuffer != null ? this.starfieldTextureFramebuffer.field_147617_g : -1;
    }

    public void updateTextures(float partialTicks) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && !Minecraft.func_71410_x().func_147113_T()) {
            this.updateRepellerShieldTexture(partialTicks);
            this.updateGasParticlesTexture((World)world, partialTicks);
            this.updateStarfieldTexture(partialTicks);
        }
    }

    public void renderPostEffects(float partialTicks) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledResolution.func_78326_a(), (double)scaledResolution.func_78328_b(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        this.applyBloodSky(partialTicks);
        this.applySwirl(partialTicks);
    }

    private void applyBloodSky(float partialTicks) {
        float mult;
        float skyTransparency = 0.0f;
        boolean hasBeat = false;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
            if ((skyTransparency += provider.getWorldData().getEnvironmentEventRegistry().BLOODSKY.getSkyTransparency(partialTicks)) > 0.01f) {
                hasBeat = true;
            }
            skyTransparency += provider.getWorldData().getEnvironmentEventRegistry().SPOOPY.getSkyTransparency(partialTicks);
        }
        if (skyTransparency <= 0.01f) {
            return;
        }
        if (skyTransparency > 1.0f) {
            skyTransparency = 1.0f;
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        double renderWidth = scaledResolution.func_78326_a();
        double renderHeight = scaledResolution.func_78328_b();
        Vec3d lightPos = new Vec3d(45.0, 40.0, 30.0);
        GLUProjection.Projection projection = GLUProjection.getInstance().project(lightPos.field_72450_a, lightPos.field_72448_b, lightPos.field_72449_c, GLUProjection.ClampMode.ORTHOGONAL, false);
        GLUProjection.Projection projectionUnclamped = GLUProjection.getInstance().project(lightPos.field_72450_a, lightPos.field_72448_b, lightPos.field_72449_c, GLUProjection.ClampMode.NONE, false);
        float rayX = (float)(projection.getX() / renderWidth);
        float rayY = (float)(projection.getY() / renderHeight);
        float rayYUnclamped = (float)(projectionUnclamped.getY() / renderWidth);
        Vec3d lookVec = Minecraft.func_71410_x().field_71439_g.func_70676_i(partialTicks);
        lookVec = new Vec3d(lookVec.field_72450_a + 1.0E-4, 0.0, lookVec.field_72449_c + 1.0E-4);
        lookVec = lookVec.func_72432_b();
        Vec3d sLightPos = new Vec3d(lightPos.field_72450_a + 1.0E-4, 0.0, lightPos.field_72449_c + 1.0E-4).func_72432_b();
        float lightXZAngle = (float)Math.toDegrees(Math.acos(sLightPos.func_72430_b(lookVec)));
        float fovX = GLUProjection.getInstance().getFovX() / 2.0f;
        float angDiff = Math.abs(lightXZAngle);
        float decay = 0.96f;
        float illuminationDecay = 0.44f;
        float weight = 0.12f;
        if (rayYUnclamped <= 0.0f) {
            mult = 1.0f + MathHelper.func_76131_a((float)(rayYUnclamped / 5.0f * (1.0f - angDiff / fovX)), (float)-1.0f, (float)0.0f);
            decay *= mult;
            illuminationDecay *= mult;
            weight *= mult;
        }
        if (angDiff > fovX) {
            mult = 1.0f - (angDiff - fovX) / 400.0f;
            decay *= mult;
            illuminationDecay *= mult;
            weight *= mult;
        }
        int depthTexture = this.depthBuffer.getTexture();
        int clipPlaneBuffer = BLSkyRenderer.INSTANCE.clipPlaneBuffer.getDepthTexture();
        if (depthTexture < 0 || clipPlaneBuffer < 0) {
            return;
        }
        Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
        Framebuffer blitFramebuffer = this.blitBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
        Framebuffer occlusionFramebuffer = this.occlusionBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
        this.occlusionExtractor.setDepthTextures(depthTexture, clipPlaneBuffer);
        this.occlusionExtractor.create(occlusionFramebuffer).setSource(Minecraft.func_71410_x().func_147110_a().field_147617_g).setPreviousFramebuffer(mainFramebuffer).render(partialTicks);
        float beat = 0.0f;
        if (hasBeat) {
            beat = Math.abs((float)Math.sin((double)System.nanoTime() / 1.0E8) / 3.0f / (Math.abs((float)Math.sin((double)System.nanoTime() / 4.0E9) * (float)Math.sin((double)System.nanoTime() / 4.0E9) * (float)Math.sin((double)System.nanoTime() / 4.0E9 + (double)0.05f) * 120.0f) * 180.0f + 15.5f) * 30.0f) / 4.0f;
        }
        float density = 0.1f + beat;
        this.godRayEffect.setOcclusionMap(occlusionFramebuffer).setParams(0.8f, decay * 1.01f, density * 1.5f, weight * 0.8f, illuminationDecay * 1.25f).setRayPos(rayX, rayY).create(blitFramebuffer).setSource(mainFramebuffer.field_147617_g).setPreviousFramebuffer(mainFramebuffer).render(partialTicks);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)0.7f, (float)0.1f, (float)0.0f, (float)(skyTransparency / 2.5f));
        GL11.glBindTexture((int)3553, (int)blitFramebuffer.field_147617_g);
        GL11.glBegin((int)4);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)renderWidth, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glEnd();
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    public void setSwirlAngle(float swirlAngle) {
        this.lastSwirlAngle = this.swirlAngle;
        this.swirlAngle = swirlAngle;
    }

    public float getSwirlAngle(float partialTicks) {
        return this.lastSwirlAngle + (this.swirlAngle - this.lastSwirlAngle) * partialTicks;
    }

    private void applySwirl(float partialTicks) {
        float interpolatedSwirlAngle = this.getSwirlAngle(partialTicks);
        if (interpolatedSwirlAngle != 0.0f) {
            Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
            Framebuffer blitFramebuffer = this.blitBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
            this.swirlEffect.setAngle(interpolatedSwirlAngle);
            this.swirlEffect.create(mainFramebuffer).setSource(mainFramebuffer.field_147617_g).setBlitFramebuffer(blitFramebuffer).setPreviousFramebuffer(mainFramebuffer).render(partialTicks);
        }
    }

    private void updateRepellerShieldTexture(float partialTicks) {
        Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
        this.repellerShieldBuffer.updateGeometryBuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
        this.repellerShieldBuffer.clear(0.0f, 0.0f, 0.0f, 0.0f, 1.0);
        this.repellerShieldBuffer.bind();
        this.repellerShieldBuffer.updateDepthBuffer();
        mainFramebuffer.func_147610_a(false);
    }

    private void updateGasParticlesTexture(World world, float partialTicks) {
        boolean hasCloud = false;
        for (Entity entity : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
            if (!(entity instanceof EntityGasCloud)) continue;
            hasCloud = true;
            break;
        }
        if (hasCloud) {
            float worldTimeInterp = (float)world.func_72820_D() + partialTicks;
            float offsetX = ((float)Math.sin((double)(worldTimeInterp / 20.0f) % (Math.PI * 2)) + 1.0f) / 600.0f;
            float offsetY = ((float)Math.cos((double)(worldTimeInterp / 20.0f) % (Math.PI * 2)) + 1.0f) / 600.0f;
            this.gasWarpEffect.setOffset(offsetX, offsetY).setWarpDir(0.75f, 0.75f).setScale(1.8f);
            this.gasTextureFramebuffer.func_147610_a(false);
            GlStateManager.func_179082_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179086_m((int)16384);
            this.gasTextureBaseFramebuffer.func_147610_a(false);
            GlStateManager.func_179082_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179086_m((int)16384);
            this.gasWarpEffect.create(this.gasTextureFramebuffer).setSource(this.gasTextureBaseFramebuffer.field_147617_g).setPreviousFramebuffer(Minecraft.func_71410_x().func_147110_a()).render(partialTicks);
        }
        this.gasParticlesBuffer.updateDepthBuffer();
    }

    private void updateStarfieldTexture(float partialTicks) {
        float offX = (float)(Minecraft.func_71410_x().func_175598_ae().field_78730_l / 8000.0);
        float offY = (float)(Minecraft.func_71410_x().func_175598_ae().field_78728_n / 8000.0);
        this.starfieldEffect.setTimeScale(2.5E-7f).setZoom(0.8f).setOffset(offX, offY, 0.0f);
        this.starfieldEffect.create(this.starfieldTextureFramebuffer).setPreviousFramebuffer(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(ConfigHandler.skyResolution, ConfigHandler.skyResolution).render(partialTicks);
    }

    @Override
    public void postRender(float partialTicks) {
        Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
        this.gasParticlesBuffer.updateGeometryBuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
        this.gasParticlesBuffer.clear(0.0f, 0.0f, 0.0f, 0.0f, 1.0);
        mainFramebuffer.func_147610_a(false);
    }
}

