/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader;

import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.shader.DepthBuffer;
import thebetweenlands.client.render.shader.FloatFramebuffer;

public class GeometryBuffer {
    private Framebuffer geometryBuffer;
    private DepthBuffer geometryDepthBuffer;
    private boolean depthBuffer = false;

    public GeometryBuffer(boolean depthBuffer) {
        this.depthBuffer = depthBuffer;
    }

    public boolean updateGeometryBuffer(int width, int height) {
        boolean changed = false;
        if (this.geometryBuffer == null) {
            this.geometryBuffer = new FloatFramebuffer(width, height, this.depthBuffer);
            changed = true;
        }
        if (width != this.geometryBuffer.field_147621_c || height != this.geometryBuffer.field_147618_d) {
            this.geometryBuffer.func_147608_a();
            this.geometryBuffer = new FloatFramebuffer(width, height, this.depthBuffer);
            changed = true;
        }
        return changed;
    }

    public boolean updateDepthBuffer() {
        boolean changed = false;
        if (this.depthBuffer && this.geometryBuffer != null) {
            if (this.geometryDepthBuffer == null) {
                this.geometryDepthBuffer = new DepthBuffer();
                changed = true;
            }
            if (this.geometryDepthBuffer.blitDepthBuffer(this.geometryBuffer)) {
                changed = true;
            }
        }
        return changed;
    }

    public int getDiffuseTexture() {
        if (this.geometryBuffer != null) {
            return this.geometryBuffer.field_147617_g;
        }
        return -1;
    }

    public int getDepthTexture() {
        if (this.depthBuffer && this.geometryDepthBuffer != null) {
            return this.geometryDepthBuffer.getTexture();
        }
        return -1;
    }

    public void bind() {
        if (this.geometryBuffer == null) {
            throw new NullPointerException("The buffers aren't initialized yet");
        }
        this.geometryBuffer.func_147610_a(false);
    }

    public void clear(float r, float g, float b, float a, double depth) {
        if (this.geometryBuffer != null) {
            this.geometryBuffer.func_147610_a(false);
            GL11.glClearColor((float)r, (float)g, (float)b, (float)a);
            GL11.glClearDepth((double)depth);
            GL11.glClear((int)16640);
        }
    }

    public void clear(float r, float g, float b, float a) {
        this.clear(r, g, b, a, 1.0);
    }

    public void deleteBuffers() {
        if (this.geometryBuffer != null) {
            this.geometryBuffer.func_147608_a();
        }
        if (this.geometryDepthBuffer != null) {
            this.geometryDepthBuffer.deleteBuffer();
        }
    }

    public boolean hasDepthBuffer() {
        return this.depthBuffer;
    }
}

