/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.common.block.terrain.BlockWisp;

public class ParticleWisp
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private float prevFlameScale;
    private float flameScale;
    private int brightness;

    protected ParticleWisp(World world, double x, double y, double z, double mx, double my, double mz, float scale, int bright) {
        super(world, x, y, z, mx, my, mz);
        this.field_187129_i = this.field_187129_i * 0.01 + mx;
        this.field_187130_j = this.field_187130_j * 0.01 + my;
        this.field_187131_k = this.field_187131_k * 0.01 + mz;
        this.field_187126_f = this.field_187123_c = (x += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187127_g = this.field_187124_d = (y += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187128_h = this.field_187125_e = (z += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.flameScale = scale;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 1000;
        this.brightness = bright;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_180434_a(VertexBuffer buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        float currentX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks);
        float currentY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks);
        float currentZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks);
        this.field_70544_f = this.prevFlameScale + (this.flameScale - this.prevFlameScale) * partialTicks;
        float distance = 0.0f;
        if (!BlockWisp.canSee(this.field_187122_b, new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h))) {
            distance = MathHelper.func_76131_a((float)ParticleWisp.getDistanceToViewer(currentX, currentY, currentZ, partialTicks), (float)10.0f, (float)20.0f);
        }
        this.func_82338_g(1.0f - MathHelper.func_76126_a((float)(0.15707964f * distance)));
        super.func_180434_a(buff, entityIn, partialTicks, rx, rz, ryz, rxy, rxz);
    }

    public int func_189214_a(float partialTicks) {
        if (this.brightness < 0) {
            return super.func_189214_a(partialTicks);
        }
        return this.brightness;
    }

    public static float getDistanceToViewer(double x, double y, double z, float partialRenderTicks) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity != null) {
            double dx = (double)((float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialRenderTicks)) - x;
            double dy = (double)((float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialRenderTicks)) - y;
            double dz = (double)((float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialRenderTicks)) - z;
            return MathHelper.func_76129_c((float)((float)(dx * dx + dy * dy + dz * dz)));
        }
        return 0.0f;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevFlameScale = this.flameScale;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.96;
        this.field_187131_k *= 0.96;
        if (this.field_70546_d++ >= this.field_70547_e || this.flameScale <= 0.0f) {
            this.func_187112_i();
        }
        if (this.field_70546_d != 0) {
            if (this.flameScale > 0.0f) {
                this.flameScale = (float)((double)this.flameScale - 0.025);
            }
            this.field_187130_j += 8.0E-5;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleWisp> {
        public Factory() {
            super(ParticleWisp.class, ParticleTextureStitcher.create(ParticleWisp.class, new ResourceLocation("thebetweenlands:particle/wisp")));
        }

        @Override
        public ParticleWisp createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleWisp(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.scale, args.data.getInt(0));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(255);
        }
    }
}

