/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.block.Block;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.sprite.TextureAnimation;
import thebetweenlands.common.block.terrain.BlockSwampWater;

public class ParticleBug
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private float jitter;
    private float speed;
    private boolean underwater;
    private double tx;
    private double ty;
    private double tz;
    protected TextureAnimation animation;

    protected ParticleBug(World world, double x, double y, double z, double mx, double my, double mz, int maxAge, float speed, float jitter, float scale, boolean underwater) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187123_c = this.tx = x;
        this.field_187126_f = this.tx;
        this.field_187124_d = this.ty = y;
        this.field_187127_g = this.ty;
        this.field_187125_e = this.tz = z;
        this.field_187128_h = this.tz;
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
        this.field_70547_e = maxAge;
        this.field_70544_f = scale;
        this.jitter = jitter;
        this.speed = speed;
        this.underwater = underwater;
        this.animation = new TextureAnimation().setRandomStart(this.field_187136_p);
    }

    public int func_70537_b() {
        return 1;
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        if (this.animation != null) {
            this.animation.setFrames(frames[0]);
            if (this.field_187119_C == null) {
                this.func_187117_a(frames[0][0].getSprite());
            }
        }
    }

    public void func_189213_a() {
        if (this.animation != null) {
            this.animation.update();
            this.func_187117_a(this.animation.getCurrentSprite());
        }
        super.func_189213_a();
        this.func_187110_a(this.field_187122_b.field_73012_v.nextFloat() * this.jitter * 2.0f - this.jitter, this.field_187122_b.field_73012_v.nextFloat() * this.jitter * 2.0f - this.jitter, this.field_187122_b.field_73012_v.nextFloat() * this.jitter * 2.0f - this.jitter);
        double distToTarget = Math.sqrt((this.tx - this.field_187126_f) * (this.tx - this.field_187126_f) + (this.ty - this.field_187127_g) * (this.ty - this.field_187127_g) + (this.tz - this.field_187128_h) * (this.tz - this.field_187128_h));
        Block currBlock = this.field_187122_b.func_180495_p(new BlockPos((int)Math.floor(this.field_187126_f), (int)Math.floor(this.field_187127_g), (int)Math.floor(this.field_187128_h))).func_177230_c();
        if (this.underwater == !(currBlock instanceof BlockSwampWater)) {
            this.field_187130_j += 0.08;
            if (this.field_187132_l) {
                this.field_187130_j += 0.25;
            }
            this.tx = this.field_187126_f;
            this.ty = this.field_187127_g;
            this.tz = this.field_187128_h;
        } else if (distToTarget <= (double)(this.speed + this.jitter)) {
            this.tx = this.field_187126_f + (double)(this.field_187122_b.field_73012_v.nextFloat() * 2.0f) - 1.0;
            this.ty = this.field_187127_g + (double)(this.field_187122_b.field_73012_v.nextFloat() * 2.0f) - 1.0;
            this.tz = this.field_187128_h + (double)(this.field_187122_b.field_73012_v.nextFloat() * 2.0f) - 1.0;
            Block targetBlock = this.field_187122_b.func_180495_p(new BlockPos((int)Math.floor(this.tx), (int)Math.floor(this.ty + 0.5), (int)Math.floor(this.tz))).func_177230_c();
            if (this.underwater == !(targetBlock instanceof BlockSwampWater)) {
                this.tx = this.field_187126_f;
                this.ty = this.field_187127_g;
                this.tz = this.field_187128_h;
            }
        } else {
            this.func_187110_a(-(this.field_187126_f - this.tx) / distToTarget * (double)this.speed, -(this.field_187127_g - this.ty) / distToTarget * (double)this.speed, -(this.field_187128_h - this.tz) / distToTarget * (double)this.speed);
        }
    }

    public static final class WaterBugFactory
    extends ParticleFactory<WaterBugFactory, ParticleBug> {
        public WaterBugFactory() {
            super(ParticleBug.class, ParticleTextureStitcher.create(ParticleBug.class, new ResourceLocation("thebetweenlands:particle/water_bug")).setSplitAnimations(true));
        }

        @Override
        public ParticleBug createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleBug(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.data.getFloat(1), args.data.getFloat(2), args.scale, args.data.getBool(3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            ((ParticleFactory.ParticleArgs)args.withScale(0.6f)).withData(400, Float.valueOf(0.03f), Float.valueOf(0.002f), true);
        }

        @Override
        protected void setDefaultArguments(World world, double x, double y, double z, ParticleFactory.ParticleArgs<?> args) {
            args.withScale(0.6f * world.field_73012_v.nextFloat() + 0.1f);
        }
    }

    public static final class MosquitoFactory
    extends ParticleFactory<MosquitoFactory, ParticleBug> {
        public MosquitoFactory() {
            super(ParticleBug.class, ParticleTextureStitcher.create(ParticleBug.class, new ResourceLocation("thebetweenlands:particle/mosquito")).setSplitAnimations(true));
        }

        @Override
        public ParticleBug createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleBug(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.data.getFloat(1), args.data.getFloat(2), args.scale, args.data.getBool(3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            ((ParticleFactory.ParticleArgs)args.withScale(0.4f)).withData(400, Float.valueOf(0.05f), Float.valueOf(0.025f), false);
        }

        @Override
        protected void setDefaultArguments(World world, double x, double y, double z, ParticleFactory.ParticleArgs<?> args) {
            args.withScale(0.4f * world.field_73012_v.nextFloat() + 0.1f);
        }
    }

    public static final class FlyFactory
    extends ParticleFactory<FlyFactory, ParticleBug> {
        public FlyFactory() {
            super(ParticleBug.class, ParticleTextureStitcher.create(ParticleBug.class, new ResourceLocation("thebetweenlands:particle/fly")).setSplitAnimations(true));
        }

        @Override
        public ParticleBug createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleBug(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.data.getFloat(1), args.data.getFloat(2), args.scale, args.data.getBool(3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            ((ParticleFactory.ParticleArgs)args.withScale(0.25f)).withData(400, Float.valueOf(0.05f), Float.valueOf(0.025f), false);
        }

        @Override
        protected void setDefaultArguments(World world, double x, double y, double z, ParticleFactory.ParticleArgs<?> args) {
            args.withScale(0.25f * world.field_73012_v.nextFloat() + 0.1f);
        }
    }
}

