/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.entity.rowboat;

import java.util.EnumMap;
import java.util.Iterator;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import thebetweenlands.client.render.model.AdvancedModelRenderer;
import thebetweenlands.client.render.model.entity.ModelBoxCustomizable;
import thebetweenlands.client.render.model.entity.rowboat.ModelBipedLimb;
import thebetweenlands.common.entity.rowboat.ShipSide;

public class ModelBipedRower
extends ModelBiped {
    private EnumMap<ShipSide, ModelBipedLimb> arms;
    private ModelRenderer leftForearm;
    private ModelRenderer rightForearm;

    public ModelBipedRower(float expand) {
        this(expand, false);
    }

    public ModelBipedRower(float expand, boolean slimArms) {
        this(expand, false, slimArms, 64, 32, new BipedTextureUVs(40, 16, 40, 16, 0, 16, 0, 16));
    }

    public ModelBipedRower(float expand, boolean expandJointed, boolean slimArms, int textureWidth, int textureHeight, BipedTextureUVs uvs) {
        super(expand, 0.0f, textureWidth, textureHeight);
        this.removeCuboids(this.field_78115_e);
        this.removeCuboids(this.field_78116_c);
        this.removeCuboids(this.field_178720_f);
        this.removeCuboids(this.field_178722_k);
        this.removeCuboids(this.field_178721_j);
        this.field_78115_e = new AdvancedModelRenderer((ModelBase)this, uvs.bodyU, uvs.bodyV);
        this.field_78115_e.func_78793_a(0.0f, 12.0f, 0.0f);
        this.field_78115_e.func_78790_a(-4.0f, -12.0f, -2.0f, 8, 12, 4, expand);
        this.field_78116_c.func_78793_a(0.0f, -12.0f, 0.0f);
        this.field_78116_c.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, expand + 0.025f);
        this.field_78115_e.func_78792_a(this.field_78116_c);
        this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_178720_f.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, expand + 0.5f);
        this.field_78116_c.func_78792_a(this.field_178720_f);
        this.field_178723_h.field_78797_d = this.field_178724_i.field_78797_d = -10.0f;
        if (expand == 0.0f || expandJointed) {
            this.arms = ShipSide.newEnumMap(ModelBipedLimb.class, new ModelBipedLimb[0]);
            ModelBipedLimb left = this.createReplacementArm(this.field_178724_i, uvs.armLeftU, uvs.armLeftV, slimArms, expand);
            this.field_178724_i = left;
            this.arms.put(ShipSide.STARBOARD, left);
            ModelBipedLimb right = this.createReplacementArm(this.field_178723_h, uvs.armRightU, uvs.armRightV, slimArms, expand);
            this.field_178723_h = right;
            this.arms.put(ShipSide.PORT, right);
        } else {
            this.field_178724_i = this.createExpandReplacementArm(this.field_178724_i, uvs.armLeftU, uvs.armLeftV, slimArms, expand);
            this.field_178723_h = this.createExpandReplacementArm(this.field_178723_h, uvs.armRightU, uvs.armRightV, slimArms, expand);
        }
        if (slimArms) {
            this.field_178723_h.field_78800_c += 1.0f;
        }
        this.field_178722_k = new ModelRenderer((ModelBase)this, uvs.legLeftU, uvs.legLeftV);
        this.field_178722_k.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, expand);
        this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        this.field_178722_k.field_78795_f = -1.25f;
        this.field_178722_k.field_78796_g = -0.314f;
        this.field_178721_j = new ModelRenderer((ModelBase)this, uvs.legRightU, uvs.legRightV);
        this.field_178721_j.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, expand);
        this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
        this.field_178721_j.field_78795_f = -1.25f;
        this.field_178721_j.field_78796_g = 0.314f;
    }

    private void removeCuboids(ModelRenderer renderer) {
        Iterator cuboids = renderer.field_78804_l.iterator();
        while (cuboids.hasNext()) {
            this.field_78092_r.remove(cuboids.next());
            cuboids.remove();
        }
    }

    private ModelBipedLimb createReplacementArm(ModelRenderer oldLimb, int textureOffsetX, int textureOffsetY, boolean slimArms, float expand) {
        ModelBipedLimb limb = new ModelBipedLimb((ModelBase)this, textureOffsetX, textureOffsetY, slimArms ? 3 : 4, 4, expand);
        limb.func_78793_a(Math.signum(oldLimb.field_78800_c) * 6.0f, oldLimb.field_78797_d, oldLimb.field_78798_e);
        this.removeCuboids(oldLimb);
        limb.field_82906_o = -2.0f;
        limb.field_82908_p = -2.0f;
        limb.field_82907_q = -2.0f;
        this.field_78115_e.func_78792_a((ModelRenderer)limb);
        return limb;
    }

    private ModelRenderer createExpandReplacementArm(ModelRenderer oldLimb, int textureOffsetX, int textureOffsetY, boolean slimArms, float expand) {
        ModelRenderer limb = new ModelRenderer((ModelBase)this, textureOffsetX, textureOffsetY);
        this.field_78115_e.func_78792_a(limb);
        limb.field_78809_i = oldLimb.field_78809_i;
        ModelBox box = (ModelBox)oldLimb.field_78804_l.get(0);
        this.removeCuboids(oldLimb);
        ModelBoxCustomizable arm = new ModelBoxCustomizable(limb, textureOffsetX, textureOffsetY, -2.0f, -2.0f, -2.0f, slimArms ? 3 : 4, 6, 4, expand);
        arm.setVisibleSides(-9);
        limb.field_78804_l.add(arm);
        limb.func_78793_a(Math.signum(oldLimb.field_78800_c) * 6.0f, oldLimb.field_78797_d, oldLimb.field_78798_e);
        ModelRenderer lowerLimb = new ModelRenderer((ModelBase)this, textureOffsetX, textureOffsetY - 6);
        if (this.field_178724_i == oldLimb) {
            this.leftForearm = lowerLimb;
        } else {
            this.rightForearm = lowerLimb;
        }
        lowerLimb.field_78809_i = oldLimb.field_78809_i;
        lowerLimb.func_78793_a(0.0f, box.field_78250_b + 6.0f, box.field_78251_c + 2.0f);
        ModelBoxCustomizable forearm = new ModelBoxCustomizable(lowerLimb, textureOffsetX, textureOffsetY + 6, -2.0f, 0.0f, -2.0f, slimArms ? 3 : 4, 6, 4, expand * 0.75f, -6);
        forearm.setVisibleSides(-5);
        lowerLimb.field_78804_l.add(forearm);
        limb.func_78792_a(lowerLimb);
        return limb;
    }

    public ModelRenderer getArm(ShipSide side) {
        return this.arms.get((Object)side);
    }

    public void setLeftArmFlexionAngle(float flexionAngle) {
        if (this.arms == null) {
            this.leftForearm.field_78795_f = flexionAngle * ((float)Math.PI / 180);
        } else {
            this.arms.get((Object)ShipSide.STARBOARD).setFlexionAngle(flexionAngle);
        }
    }

    public void setRightArmFlexionAngle(float flexionAngle) {
        if (this.arms == null) {
            this.rightForearm.field_78795_f = flexionAngle * ((float)Math.PI / 180);
        } else {
            this.arms.get((Object)ShipSide.PORT).setFlexionAngle(flexionAngle);
        }
    }

    public void func_78088_a(Entity entity, float swing, float speed, float age, float yaw, float pitch, float scale) {
        this.field_78115_e.func_78785_a(scale);
        this.field_178721_j.func_78785_a(scale);
        this.field_178722_k.func_78785_a(scale);
    }

    public void func_78087_a(float swing, float speed, float age, float yaw, float pitch, float scale, Entity entity) {
    }

    public static class BipedTextureUVs {
        int armLeftU;
        int armLeftV;
        int armRightU;
        int armRightV;
        int legLeftU;
        int legLeftV;
        int legRightU;
        int legRightV;
        int bodyU;
        int bodyV;

        public BipedTextureUVs(int armLeftU, int armLeftV, int armRightU, int armRightV, int legLeftU, int legLeftV, int legRightU, int legRightV) {
            this(armLeftU, armLeftV, armRightU, armRightV, legLeftU, legLeftV, legRightU, legRightV, 16, 16);
        }

        public BipedTextureUVs(int armLeftU, int armLeftV, int armRightU, int armRightV, int legLeftU, int legLeftV, int legRightU, int legRightV, int bodyU, int bodyV) {
            this.armLeftU = armLeftU;
            this.armLeftV = armLeftV;
            this.armRightU = armRightU;
            this.armRightV = armRightV;
            this.legLeftU = legLeftU;
            this.legLeftV = legLeftV;
            this.legRightU = legRightU;
            this.legRightV = legRightV;
            this.bodyU = bodyU;
            this.bodyV = bodyV;
        }
    }
}

