/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.block.plant.BlockWeedwoodBush;
import thebetweenlands.util.QuadBuilder;

public class ModelWeedwoodBush
implements IModel {
    public static final ResourceLocation TEXTURE_LEAVES = new ResourceLocation("thebetweenlands", "blocks/leaves_weedwood_tree");
    public static final ResourceLocation TEXTURE_STICKS = new ResourceLocation("thebetweenlands", "items/weedwood_stick");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.unmodifiableCollection(Arrays.asList(TEXTURE_LEAVES, TEXTURE_STICKS));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new ModelBakedWeedwoodBush(format, state.apply(Optional.absent()), map, (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_LEAVES), (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_STICKS));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static class ModelBakedWeedwoodBush
    implements IBakedModel,
    IPerspectiveAwareModel {
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final VertexFormat format;
        private final TextureAtlasSprite textureLeaves;
        private final TextureAtlasSprite textureSticks;

        private ModelBakedWeedwoodBush(VertexFormat format, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, TextureAtlasSprite textureLeaves, TextureAtlasSprite textureSticks) {
            this.transformation = transformation.isPresent() ? (TRSRTransformation)transformation.get() : null;
            this.transforms = transforms;
            this.format = format;
            this.textureLeaves = textureLeaves;
            this.textureSticks = textureSticks;
        }

        public List<BakedQuad> func_188616_a(IBlockState stateOld, EnumFacing side, long rand) {
            IExtendedBlockState state = (IExtendedBlockState)stateOld;
            List<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (side == null) {
                float mini = 0.0f;
                float minj = 0.0f;
                float mink = 0.0f;
                float maxi = 0.0f;
                float maxj = 0.0f;
                float maxk = 0.0f;
                int posX = 0;
                int posY = 0;
                int posZ = 0;
                try {
                    if (((Boolean)state.func_177229_b((IProperty)BlockWeedwoodBush.WEST)).booleanValue()) {
                        mini = -0.25f;
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockWeedwoodBush.EAST)).booleanValue()) {
                        maxi = 0.25f;
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockWeedwoodBush.DOWN)).booleanValue()) {
                        minj = -0.25f;
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockWeedwoodBush.UP)).booleanValue()) {
                        maxj = 0.25f;
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockWeedwoodBush.NORTH)).booleanValue()) {
                        mink = -0.25f;
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockWeedwoodBush.SOUTH)).booleanValue()) {
                        maxk = 0.25f;
                    }
                    posX = (Integer)state.getValue((IUnlistedProperty)BlockWeedwoodBush.POS_X);
                    posY = (Integer)state.getValue((IUnlistedProperty)BlockWeedwoodBush.POS_Y);
                    posZ = (Integer)state.getValue((IUnlistedProperty)BlockWeedwoodBush.POS_Z);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                QuadBuilder builder = new QuadBuilder(this.format).setTransformation(this.transformation);
                builder.setSprite(this.textureLeaves);
                builder.addVertex(0.0, 0.25 + (double)minj, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.25 + (double)minj, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.0, 0.75, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.25, 1.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.25, 1.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.75, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.25, 0.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.25, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.25, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.25 + (double)mink, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.25 + (double)mink, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.75 + (double)maxk, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.75 + (double)maxk, 16.0f, 0.0f);
                builder.addVertex(0.75, 1.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.75, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.75, 1.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.75, 0.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.25 + (double)minj, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.75 + (double)maxj, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75 + (double)maxj, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25 + (double)minj, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.0, 0.25 + (double)minj, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.25, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.75 + (double)maxj, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.25 + (double)minj, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.75, 0.25 + (double)minj, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.75 + (double)maxj, 0.0, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.25, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.25, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.75, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.25, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.25, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.25, 16.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25 + (double)minj, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75 + (double)maxj, 1.0, 0.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.75 + (double)maxj, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.25 + (double)minj, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.75, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75, 1.0, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.75, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.75, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.75, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.75, 0.75 + (double)maxj, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.75, 0.25 + (double)minj, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25, 0.25 + (double)minj, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.25, 0.75 + (double)maxj, 1.0, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.75, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.25 + (double)minj, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.75, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.25, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.0, 0.25, 0.0f, 16.0f);
                builder.addVertex(0.75, 0.25, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.75, 0.25, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.75, 0.25, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.0, 0.75, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.25, 0.75, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.75, 1.0, 0.75, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.75, 1.0, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.75, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.75, 0.75, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.75, 1.0, 0.25, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.75, 0.75, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.0, 0.25, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.25, 0.25, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.25, 16.0f, 0.0f);
                builder.addVertex(0.25, 1.0, 0.75, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.75, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.75, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.75, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25, 0.25, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.25, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.75, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.25, 1.0, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.25, 0.75, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.75, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.75, 0.25, 16.0f, 0.0f);
                if (Minecraft.func_71375_t()) {
                    builder.addVertex(0.1, 0.5, -0.1, 0.0f, 0.0f);
                    builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                    builder.addVertex(0.9, 0.5, 1.1, 16.0f, 16.0f);
                    builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                    builder.addVertex(0.9, 0.5, 1.1, 0.0f, 0.0f);
                    builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                    builder.addVertex(0.1, 0.5, -0.1, 16.0f, 16.0f);
                    builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                    builder.addVertex(0.1, 0.5, 0.7, 0.0f, 0.0f);
                    builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                    builder.addVertex(0.9, 0.5, 0.3, 16.0f, 16.0f);
                    builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                    builder.addVertex(0.9, 0.5, 0.3, 0.0f, 0.0f);
                    builder.addVertex(0.3, 1.1, 0.5, 16.0f, 0.0f);
                    builder.addVertex(0.1, 0.5, 0.7, 16.0f, 16.0f);
                    builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                    builder.addVertex(0.3, 0.5, 1.1, 0.0f, 0.0f);
                    builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                    builder.addVertex(0.9, 0.5, -0.1, 16.0f, 16.0f);
                    builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                    builder.addVertex(0.9, 0.5, -0.1, 0.0f, 0.0f);
                    builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                    builder.addVertex(0.3, 0.5, 1.1, 16.0f, 16.0f);
                    builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                    builder.setSprite(this.textureSticks);
                    int cSticks = 5;
                    Random rnd = new Random();
                    long seed = (long)posX * 3129871L ^ (long)posY * 116129781L ^ (long)posZ;
                    rnd.setSeed(seed * seed * 42317861L + seed * 11L);
                    for (int i = 0; i < cSticks; ++i) {
                        double rotation = Math.PI * 2 / (double)cSticks * (double)i;
                        double xp1 = Math.sin(rotation) * (double)0.4f;
                        double zp1 = Math.cos(rotation) * (double)0.4f;
                        double xp2 = Math.sin(rotation + 1.5707963267948966) * (double)0.4f;
                        double zp2 = Math.cos(rotation + 1.5707963267948966) * (double)0.4f;
                        double xp3 = Math.sin(rotation + Math.PI) * (double)0.4f;
                        double zp3 = Math.cos(rotation + Math.PI) * (double)0.4f;
                        double xp4 = Math.sin(rotation + Math.PI + 1.5707963267948966) * (double)0.4f;
                        double zp4 = Math.cos(rotation + Math.PI + 1.5707963267948966) * (double)0.4f;
                        float xOff = (rnd.nextFloat() * 2.0f - 1.0f) * 0.4f + 0.5f;
                        float yOff = (rnd.nextFloat() * 2.0f - 1.0f) * 0.4f;
                        float zOff = (rnd.nextFloat() * 2.0f - 1.0f) * 0.4f + 0.5f;
                        builder.addVertex(xp1 + (double)xOff, 0.8 + (double)yOff, zp1 + (double)zOff, 0.0f, 0.0f);
                        builder.addVertex(xp2 + (double)xOff, 0.8 + (double)yOff, zp2 + (double)zOff, 16.0f, 0.0f);
                        builder.addVertex(xp3 + (double)xOff, 0.2 + (double)yOff, zp3 + (double)zOff, 16.0f, 16.0f);
                        builder.addVertex(xp4 + (double)xOff, 0.2 + (double)yOff, zp4 + (double)zOff, 0.0f, 16.0f);
                        builder.addVertex(xp1 + (double)xOff, 0.8 + (double)yOff, zp1 + (double)zOff, 0.0f, 0.0f);
                        builder.addVertex(xp4 + (double)xOff, 0.2 + (double)yOff, zp4 + (double)zOff, 0.0f, 16.0f);
                        builder.addVertex(xp3 + (double)xOff, 0.2 + (double)yOff, zp3 + (double)zOff, 16.0f, 16.0f);
                        builder.addVertex(xp2 + (double)xOff, 0.8 + (double)yOff, zp2 + (double)zOff, 16.0f, 0.0f);
                    }
                }
                quads = builder.build();
            }
            return quads;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textureLeaves;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }
}

