/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.block.structure.BlockThatchRoof;
import thebetweenlands.util.QuadBuilder;

public class ModelThatchRoof
implements IModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "blocks/thatch");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.unmodifiableCollection(Arrays.asList(TEXTURE));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new ModelBakedThatchRoof(state.apply(Optional.absent()), map, format, (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static class ModelBakedThatchRoof
    implements IPerspectiveAwareModel {
        private final VertexFormat format;
        private final TextureAtlasSprite texture;
        private float slopeEdge = 0.1875f;
        private final EnumMap<EnumFacing, List<BakedQuad>> faceQuads;
        private final List<BakedQuad> nonCulledQuads = new ArrayList<BakedQuad>();
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final LoadingCache<Integer, ModelBakedThatchRoof> modelCache = CacheBuilder.newBuilder().maximumSize(64L).build((CacheLoader)new CacheLoader<Integer, ModelBakedThatchRoof>(){

            public ModelBakedThatchRoof load(Integer key) throws Exception {
                return new ModelBakedThatchRoof(transformation != null ? Optional.of((Object)transformation) : Optional.absent(), transforms, format, texture, key);
            }
        });

        private ModelBakedThatchRoof(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, TextureAtlasSprite texture) {
            this.transformation = transformation.isPresent() ? (TRSRTransformation)transformation.get() : null;
            this.transforms = transforms;
            this.format = format;
            this.texture = texture;
            this.faceQuads = Maps.newEnumMap(EnumFacing.class);
            for (EnumFacing side : EnumFacing.values()) {
                this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of());
            }
        }

        private ModelBakedThatchRoof(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, TextureAtlasSprite texture, Integer key) {
            this(transformation, transforms, format, texture);
            boolean corner1 = (key & 1) != 0;
            boolean corner2 = (key & 2) != 0;
            boolean corner3 = (key & 4) != 0;
            boolean corner4 = (key & 8) != 0;
            boolean upsidedown = (key & 0x10) != 0;
            float cornerHeight1 = corner1 ? 1.0f : this.slopeEdge;
            float cornerHeight2 = corner2 ? 1.0f : this.slopeEdge;
            float cornerHeight3 = corner3 ? 1.0f : this.slopeEdge;
            float cornerHeight4 = corner4 ? 1.0f : this.slopeEdge;
            QuadBuilder builder = new QuadBuilder(this.format).setTransformation(this.transformation).setSprite(this.texture);
            if (!upsidedown) {
                builder.addVertex(0.0, 0.0, 1.0E-4f, 0.0f, 0.0f);
                builder.addVertex(0.0, cornerHeight1, 1.0E-4f, 0.0f, cornerHeight1 * 16.0f);
                builder.addVertex(1.0, cornerHeight2, 1.0E-4f, 16.0f, cornerHeight2 * 16.0f);
                builder.addVertex(1.0, 0.0, 1.0E-4f, 16.0f, 0.0f);
                this.faceQuads.put(EnumFacing.NORTH, builder.build());
                builder.addVertex(0.0, 0.0, 1.0, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.0, 1.0, 16.0f, 0.0f);
                builder.addVertex(1.0, cornerHeight3, 1.0, 16.0f, cornerHeight3 * 16.0f);
                builder.addVertex(0.0, cornerHeight4, 1.0, 0.0f, cornerHeight4 * 16.0f);
                this.faceQuads.put(EnumFacing.SOUTH, builder.build());
                builder.addVertex(1.0, 0.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(1.0, cornerHeight2, 0.0, 0.0f, cornerHeight2 * 16.0f);
                builder.addVertex(1.0, cornerHeight3, 1.0, 16.0f, cornerHeight3 * 16.0f);
                builder.addVertex(1.0, 0.0, 1.0, 16.0f, 0.0f);
                this.faceQuads.put(EnumFacing.EAST, builder.build());
                builder.addVertex(1.0E-4f, 0.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(1.0E-4f, 0.0, 1.0, 16.0f, 0.0f);
                builder.addVertex(1.0E-4f, cornerHeight4, 1.0, 16.0f, cornerHeight4 * 16.0f);
                builder.addVertex(1.0E-4f, cornerHeight1, 0.0, 0.0f, cornerHeight1 * 16.0f);
                this.faceQuads.put(EnumFacing.WEST, builder.build());
                if ((corner2 || corner4) && !corner1 && !corner3 || corner1 == corner3) {
                    builder.addVertex(0.0, cornerHeight4, 1.0, 16.0f, 0.0f);
                    builder.addVertex(1.0, cornerHeight3, 1.0, 16.0f, 16.0f);
                    builder.addVertex(1.0, cornerHeight2, 0.0, 0.0f, 16.0f);
                    builder.addVertex(0.0, cornerHeight1, 0.0, 0.0f, 0.0f);
                } else {
                    builder.addVertex(0.0, cornerHeight1, 0.0, 0.0f, 0.0f);
                    builder.addVertex(0.0, cornerHeight4, 1.0, 16.0f, 0.0f);
                    builder.addVertex(1.0, cornerHeight3, 1.0, 16.0f, 16.0f);
                    builder.addVertex(1.0, cornerHeight2, 0.0, 0.0f, 16.0f);
                }
                this.nonCulledQuads.addAll(builder.build());
                builder.addVertex(0.0, 0.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.0, 0.0, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.0, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.0, 1.0, 16.0f, 0.0f);
                this.faceQuads.put(EnumFacing.DOWN, builder.build());
            } else {
                builder.addVertex(0.0, 1.0, 1.0E-4f, 0.0f, 0.0f);
                builder.addVertex(1.0, 1.0, 1.0E-4f, 16.0f, 0.0f);
                builder.addVertex(1.0, 1.0f - cornerHeight2, 1.0E-4f, 16.0f, cornerHeight2 * 16.0f);
                builder.addVertex(0.0, 1.0f - cornerHeight1, 1.0E-4f, 0.0f, cornerHeight1 * 16.0f);
                this.faceQuads.put(EnumFacing.NORTH, builder.build());
                builder.addVertex(0.0, 1.0, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.0, 1.0f - cornerHeight4, 1.0, 0.0f, cornerHeight4 * 16.0f);
                builder.addVertex(1.0, 1.0f - cornerHeight3, 1.0, 16.0f, cornerHeight3 * 16.0f);
                builder.addVertex(1.0, 1.0, 1.0, 16.0f, 0.0f);
                this.faceQuads.put(EnumFacing.SOUTH, builder.build());
                builder.addVertex(1.0, 1.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(1.0, 1.0, 1.0, 16.0f, 0.0f);
                builder.addVertex(1.0, 1.0f - cornerHeight3, 1.0, 16.0f, cornerHeight3 * 16.0f);
                builder.addVertex(1.0, 1.0f - cornerHeight2, 0.0, 0.0f, cornerHeight2 * 16.0f);
                this.faceQuads.put(EnumFacing.EAST, builder.build());
                builder.addVertex(1.0E-4f, 1.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(1.0E-4f, 1.0f - cornerHeight1, 0.0, 0.0f, cornerHeight1 * 16.0f);
                builder.addVertex(1.0E-4f, 1.0f - cornerHeight4, 1.0, 16.0f, cornerHeight4 * 16.0f);
                builder.addVertex(1.0E-4f, 1.0, 1.0, 16.0f, 0.0f);
                this.faceQuads.put(EnumFacing.WEST, builder.build());
                if ((corner2 || corner4) && !corner1 && !corner3 || corner1 == corner3) {
                    builder.addVertex(0.0, 1.0f - cornerHeight4, 1.0, 16.0f, 0.0f);
                    builder.addVertex(0.0, 1.0f - cornerHeight1, 0.0, 0.0f, 0.0f);
                    builder.addVertex(1.0, 1.0f - cornerHeight2, 0.0, 0.0f, 16.0f);
                    builder.addVertex(1.0, 1.0f - cornerHeight3, 1.0, 16.0f, 16.0f);
                } else {
                    builder.addVertex(0.0, 1.0f - cornerHeight1, 0.0, 0.0f, 0.0f);
                    builder.addVertex(1.0, 1.0f - cornerHeight2, 0.0, 0.0f, 16.0f);
                    builder.addVertex(1.0, 1.0f - cornerHeight3, 1.0, 16.0f, 16.0f);
                    builder.addVertex(0.0, 1.0f - cornerHeight4, 1.0, 16.0f, 0.0f);
                }
                this.nonCulledQuads.addAll(builder.build());
                builder.addVertex(0.0, 1.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.0, 1.0, 1.0, 16.0f, 0.0f);
                builder.addVertex(1.0, 1.0, 1.0, 16.0f, 16.0f);
                builder.addVertex(1.0, 1.0, 0.0, 0.0f, 16.0f);
                this.faceQuads.put(EnumFacing.UP, builder.build());
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            boolean upsidedown = state != null ? state.func_177229_b((IProperty)BlockThatchRoof.field_176308_b) == BlockStairs.EnumHalf.TOP : false;
            boolean corner1 = false;
            boolean corner2 = false;
            boolean corner3 = false;
            boolean corner4 = false;
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState extendedState = (IExtendedBlockState)state;
                corner1 = (Boolean)extendedState.getValue(BlockThatchRoof.CORNER_1);
                corner2 = (Boolean)extendedState.getValue(BlockThatchRoof.CORNER_2);
                corner3 = (Boolean)extendedState.getValue(BlockThatchRoof.CORNER_3);
                corner4 = (Boolean)extendedState.getValue(BlockThatchRoof.CORNER_4);
            } else {
                corner1 = true;
                corner2 = false;
                corner3 = false;
                corner4 = true;
            }
            int index = 0;
            if (corner1) {
                index |= 1;
            }
            if (corner2) {
                index |= 2;
            }
            if (corner3) {
                index |= 4;
            }
            if (corner4) {
                index |= 8;
            }
            if (upsidedown) {
                index |= 0x10;
            }
            ModelBakedThatchRoof model = (ModelBakedThatchRoof)this.modelCache.getUnchecked((Object)index);
            return side == null ? model.nonCulledQuads : model.faceQuads.get(side);
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.texture;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }
}

