/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import thebetweenlands.common.block.terrain.BlockLifeCrystalStalactite;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.StalactiteHelper;

public class ModelLifeCrystalStalactite
implements IModel {
    public static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("thebetweenlands", "blocks/pitstone");
    public static final ResourceLocation TEXTURE_ORE_BACKGROUND = new ResourceLocation("thebetweenlands", "blocks/life_crystal_ore_background");
    public static final ResourceLocation TEXTURE_ORE = new ResourceLocation("thebetweenlands", "blocks/life_crystal_ore");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.unmodifiableCollection(Arrays.asList(TEXTURE_DEFAULT, TEXTURE_ORE_BACKGROUND, TEXTURE_ORE));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new ModelBakedLifeCrystalOre(format, (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_DEFAULT), (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_ORE_BACKGROUND), (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_ORE));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static class ModelBakedLifeCrystalOre
    implements IBakedModel {
        private final VertexFormat format;
        private final TextureAtlasSprite textureDefault;
        private final TextureAtlasSprite textureOreBackground;
        private final TextureAtlasSprite textureOre;

        private ModelBakedLifeCrystalOre(VertexFormat format, TextureAtlasSprite textureDefault, TextureAtlasSprite textureOreBackground, TextureAtlasSprite textureOre) {
            this.format = format;
            this.textureDefault = textureDefault;
            this.textureOreBackground = textureOreBackground;
            this.textureOre = textureOre;
        }

        public List<BakedQuad> func_188616_a(IBlockState stateOld, EnumFacing side, long rand) {
            IExtendedBlockState state = (IExtendedBlockState)stateOld;
            List<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (side == null) {
                try {
                    float distToMidTop;
                    float distToMidBottom;
                    double halfTotalHeightSQ;
                    BlockLifeCrystalStalactite.EnumLifeCrystalType type = (BlockLifeCrystalStalactite.EnumLifeCrystalType)((Object)state.func_177229_b(BlockLifeCrystalStalactite.VARIANT));
                    int distUp = (Integer)state.getValue((IUnlistedProperty)BlockLifeCrystalStalactite.DIST_UP);
                    int distDown = (Integer)state.getValue((IUnlistedProperty)BlockLifeCrystalStalactite.DIST_DOWN);
                    boolean noTop = (Boolean)state.getValue((IUnlistedProperty)BlockLifeCrystalStalactite.NO_TOP);
                    boolean noBottom = (Boolean)state.getValue((IUnlistedProperty)BlockLifeCrystalStalactite.NO_BOTTOM);
                    int posX = (Integer)state.getValue((IUnlistedProperty)BlockLifeCrystalStalactite.POS_X);
                    int posY = (Integer)state.getValue((IUnlistedProperty)BlockLifeCrystalStalactite.POS_Y);
                    int posZ = (Integer)state.getValue((IUnlistedProperty)BlockLifeCrystalStalactite.POS_Z);
                    float height = distUp == 0 && noTop ? 0.75f : 1.0f;
                    int totalHeight = 1 + distDown + distUp;
                    double squareAmount = 1.2;
                    if (noTop) {
                        halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
                        distToMidBottom = Math.abs(distUp + 1);
                        distToMidTop = Math.abs(distUp);
                    } else if (noBottom) {
                        halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
                        distToMidBottom = Math.abs(distDown);
                        distToMidTop = Math.abs(distDown + 1);
                    } else {
                        float halfTotalHeight = (float)totalHeight * 0.5f;
                        halfTotalHeightSQ = Math.pow(halfTotalHeight, squareAmount);
                        distToMidBottom = Math.abs(halfTotalHeight - (float)distUp - 1.0f);
                        distToMidTop = Math.abs(halfTotalHeight - (float)distUp);
                    }
                    int minValBottom = noBottom && distDown == 0 ? 0 : 1;
                    int minValTop = noTop && distUp == 0 ? 0 : 1;
                    int scaledValBottom = (int)(Math.pow(distToMidBottom, squareAmount) / halfTotalHeightSQ * (double)(8 - minValBottom)) + minValBottom;
                    int scaledValTop = (int)(Math.pow(distToMidTop, squareAmount) / halfTotalHeightSQ * (double)(8 - minValTop)) + minValTop;
                    float umin = 0.0f;
                    float umax = 16.0f;
                    float vmin = 0.0f;
                    float vmax = 16.0f;
                    float bottomLightingFix = distDown == 0 && noBottom ? 1.0E-4f : 0.0f;
                    float topLightingFix = distUp == 0 && noTop ? 1.0E-4f : 0.0f;
                    float halfSize = (float)scaledValBottom / 16.0f + bottomLightingFix;
                    float halfSizeTexW = halfSize * (umax - umin);
                    float halfSize1 = (float)scaledValTop / 16.0f + topLightingFix;
                    float halfSizeTex1 = halfSize1 * (umax - umin);
                    StalactiteHelper core = StalactiteHelper.getValsFor(posX, posY, posZ);
                    if (distDown == 0 && !noBottom) {
                        core.bX = 0.5;
                        core.bZ = 0.5;
                    }
                    if (distUp == 0 && !noTop) {
                        core.tX = 0.5;
                        core.tZ = 0.5;
                    }
                    QuadBuilder builder = new QuadBuilder(this.format);
                    for (int i = 0; i < (type == BlockLifeCrystalStalactite.EnumLifeCrystalType.DEFAULT ? 1 : 2); ++i) {
                        if (type == BlockLifeCrystalStalactite.EnumLifeCrystalType.DEFAULT) {
                            builder.setSprite(this.textureDefault);
                        } else if (i == 0) {
                            builder.setSprite(this.textureOreBackground);
                        } else if (i == 1) {
                            builder.setSprite(this.textureOre);
                        }
                        builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ - (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                        builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ + (double)halfSize, umin, vmax);
                        builder.addVertex(core.tX - (double)halfSize1, height, core.tZ + (double)halfSize1, umin, vmin);
                        builder.addVertex(core.tX - (double)halfSize1, height, core.tZ - (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                        builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                        builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmax);
                        builder.addVertex(core.tX + (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin);
                        builder.addVertex(core.tX + (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                        builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ - (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                        builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmax);
                        builder.addVertex(core.tX - (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin);
                        builder.addVertex(core.tX + (double)halfSize1, height, core.tZ - (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                        builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                        builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ + (double)halfSize, umin, vmax);
                        builder.addVertex(core.tX + (double)halfSize1, height, core.tZ + (double)halfSize1, umin, vmin);
                        builder.addVertex(core.tX - (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                        if (distUp == 0) {
                            builder.addVertex(core.tX - (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin);
                            builder.addVertex(core.tX - (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                            builder.addVertex(core.tX + (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin + halfSizeTex1 * 2.0f);
                            builder.addVertex(core.tX + (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin + halfSizeTex1 * 2.0f);
                        }
                        if (distDown != 0) continue;
                        builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmin);
                        builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmin);
                        builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmin + halfSizeTexW * 2.0f);
                        builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmin + halfSizeTexW * 2.0f);
                    }
                    quads = builder.build();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return quads;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textureDefault;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

