/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.util.ModelConverter;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.Vec3UV;

public class ModelFromModelBase
implements IModelCustomData {
    public final ModelBase model;
    public final ResourceLocation texture;
    public final ResourceLocation particleTexture;
    public final int width;
    public final int height;
    public final IVertexProcessor vertexProcessor;
    private boolean ambientOcclusion = true;

    public ModelFromModelBase(ModelBase model, ResourceLocation texture, int width, int height) {
        this(model, texture, texture, width, height, null);
    }

    public ModelFromModelBase(ModelBase model, ResourceLocation texture, int width, int height, @Nullable IVertexProcessor vertexProcessor) {
        this(model, texture, texture, width, height, vertexProcessor);
    }

    public ModelFromModelBase(ModelBase model, ResourceLocation texture, ResourceLocation particleTexture, int width, int height) {
        this(model, texture, particleTexture, width, height, null);
    }

    public ModelFromModelBase(ModelBase model, ResourceLocation texture, ResourceLocation particleTexture, int width, int height, @Nullable IVertexProcessor vertexProcessor) {
        this.model = model;
        this.texture = texture;
        this.width = width;
        this.height = height;
        this.vertexProcessor = vertexProcessor;
        this.particleTexture = particleTexture;
    }

    public ModelFromModelBase setAmbientOcclusion(boolean ao) {
        this.ambientOcclusion = ao;
        return this;
    }

    public boolean isAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        if (this.particleTexture != this.texture) {
            return ImmutableSet.of((Object)this.texture, (Object)this.particleTexture);
        }
        return ImmutableSet.of((Object)this.texture);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new ModelBakedModelBase(this.vertexProcessor, (Optional<TRSRTransformation>)state.apply(Optional.absent()), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format, this.model, (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.texture), (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.particleTexture), this.width, this.height, this.ambientOcclusion);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public ModelFromModelBase process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"particle_texture")) {
            return this;
        }
        JsonParser parser = new JsonParser();
        String particleTexture = parser.parse((String)customData.get((Object)"particle_texture")).getAsString();
        boolean ambientOcclusion = this.isAmbientOcclusion();
        if (customData.containsKey((Object)"ambient_occlusion")) {
            ambientOcclusion = parser.parse((String)customData.get((Object)"ambient_occlusion")).getAsBoolean();
        }
        return new ModelFromModelBase(this.model, this.texture, new ResourceLocation(particleTexture), this.width, this.height, this.vertexProcessor).setAmbientOcclusion(ambientOcclusion);
    }

    public static class ModelBakedModelBase
    implements IPerspectiveAwareModel {
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        protected final VertexFormat format;
        protected final TextureAtlasSprite texture;
        protected final TextureAtlasSprite particleTexture;
        protected final List<BakedQuad> quads;
        protected final boolean ambientOcclusion;

        protected ModelBakedModelBase(IVertexProcessor vertexProcessor, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, ModelBase model, TextureAtlasSprite texture, TextureAtlasSprite particleTexture, int width, int height, boolean ambientOcclusion) {
            this.transformation = transformation.isPresent() ? (TRSRTransformation)transformation.get() : null;
            this.transforms = transforms;
            this.format = format;
            this.texture = texture;
            this.particleTexture = particleTexture;
            ModelConverter converter = new ModelConverter(model, 0.0625, true);
            ModelConverter.Model convertedModel = converter.getModel();
            QuadBuilder builder = new QuadBuilder(this.format).setSprite(this.texture).setTransformation(this.transformation);
            for (ModelConverter.Box box : convertedModel.getBoxes()) {
                for (ModelConverter.Quad quad : box.getQuads()) {
                    for (int i = 0; i < quad.getVertices().length; ++i) {
                        Vec3UV vert = quad.getVertices()[i];
                        if (vertexProcessor != null) {
                            vert = vertexProcessor.process(vert, quad, box);
                        }
                        if (vert == null) continue;
                        builder.addVertex(vert.x + 0.5, 1.5 - vert.y, vert.z + 0.5, vert.getU(16.0f, width), vert.getV(16.0f, height));
                    }
                }
            }
            this.quads = builder.build();
            this.ambientOcclusion = ambientOcclusion;
        }

        public List<BakedQuad> func_188616_a(IBlockState stateOld, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }

    public static interface IVertexProcessor {
        public Vec3UV process(Vec3UV var1, ModelConverter.Quad var2, ModelConverter.Box var3);
    }
}

