/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParser;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ModelDynBucketBL
implements IModel,
IModelCustomData {
    private final IModel model;
    private final ResourceLocation baseLocation;
    private final ResourceLocation liquidLocation;
    private final ResourceLocation coverLocation;

    public ModelDynBucketBL() {
        this.model = ModelDynBucket.MODEL;
        this.baseLocation = null;
        this.liquidLocation = null;
        this.coverLocation = null;
    }

    public ModelDynBucketBL(ResourceLocation baseLocation, ResourceLocation liquidLocation, ResourceLocation coverLocation, Fluid fluid, boolean flipGas) {
        this.model = new ModelDynBucket(baseLocation, liquidLocation, coverLocation, fluid, flipGas);
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.model.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return this.model.bake(state, format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return this.model.getDefaultState();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        Fluid fluid = null;
        if (customData.containsKey((Object)"default_fluid")) {
            String fluidName = parser.parse((String)customData.get((Object)"default_fluid")).getAsString();
            fluid = FluidRegistry.getFluid((String)fluidName);
        }
        boolean flip = false;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = parser.parse((String)customData.get((Object)"flipGas")).getAsString();
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        ResourceLocation baseLocation = null;
        ResourceLocation liquidLocation = null;
        ResourceLocation coverLocation = null;
        baseLocation = customData.containsKey((Object)"base_texture") ? new ResourceLocation(parser.parse((String)customData.get((Object)"base_texture")).getAsString()) : this.baseLocation;
        liquidLocation = customData.containsKey((Object)"liquid_template") ? new ResourceLocation(parser.parse((String)customData.get((Object)"liquid_template")).getAsString()) : this.liquidLocation;
        coverLocation = customData.containsKey((Object)"cover_texture") ? new ResourceLocation(parser.parse((String)customData.get((Object)"cover_texture")).getAsString()) : this.coverLocation;
        return new ModelDynBucketBL(baseLocation, liquidLocation, coverLocation, fluid, flip);
    }
}

