/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.util.QuadBuilder;

public class ModelConnectedTexture
implements IModelCustomData {
    protected final List<ConnectedTextureQuad> connectedTextures;
    protected final ResourceLocation particleTexture;
    protected final boolean ambientOcclusion;

    public ModelConnectedTexture() {
        this(TextureMap.field_174945_f, true, (List<ConnectedTextureQuad>)ImmutableList.of());
    }

    public ModelConnectedTexture(ResourceLocation particleTexture, boolean ambientOcclusion, List<ConnectedTextureQuad> textures) {
        this.particleTexture = particleTexture;
        this.ambientOcclusion = ambientOcclusion;
        this.connectedTextures = textures;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        if (!this.connectedTextures.isEmpty()) {
            ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
            for (ConnectedTextureQuad quad : this.connectedTextures) {
                Collections.addAll(textures, quad.textures);
            }
            return textures;
        }
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        Optional transformation = state.apply(Optional.absent());
        for (ConnectedTextureQuad connectedTexture : this.connectedTextures) {
            connectedTexture.bake(bakedTextureGetter, (Optional<TRSRTransformation>)transformation, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format);
        }
        return new ModelBakedConnectedFace(transformation, map, format, (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.particleTexture), this.ambientOcclusion, this.connectedTextures);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        boolean changed = false;
        List<ConnectedTextureQuad> connectedTextures = this.connectedTextures;
        if (customData.containsKey((Object)"connected_texture_faces")) {
            changed = true;
            connectedTextures = new ArrayList<ConnectedTextureQuad>();
            JsonElement jsonObj = parser.parse((String)customData.get((Object)"connected_texture_faces"));
            Preconditions.checkState((jsonObj != null && !jsonObj.isJsonNull() && jsonObj.isJsonArray() ? 1 : 0) != 0, (Object)"Connected texture model must provide a connected_texture_faces array");
            JsonArray array = jsonObj.getAsJsonArray();
            for (JsonElement element : array) {
                JsonObject ctJson = element.getAsJsonObject();
                Preconditions.checkState((ctJson.has("indices") && ctJson.get("indices").isJsonArray() && ctJson.get("indices").getAsJsonArray().size() == 4 ? 1 : 0) != 0, (Object)"Connected texture face must provide 4 indices");
                String[] indices = new String[4];
                JsonArray indicesArray = ctJson.get("indices").getAsJsonArray();
                for (int i = 0; i < 4; ++i) {
                    indices[i] = indicesArray.get(i).getAsString();
                }
                Preconditions.checkState((ctJson.has("vertices") && ctJson.get("vertices").isJsonArray() && ctJson.get("vertices").getAsJsonArray().size() == 4 ? 1 : 0) != 0, (Object)"Connected texture face must provide 4 vertices");
                Vec3d[] vertices = new Vec3d[4];
                JsonArray verticesArray = ctJson.get("vertices").getAsJsonArray();
                for (int i = 0; i < 4; ++i) {
                    JsonObject vertexJson = verticesArray.get(i).getAsJsonObject();
                    vertices[i] = new Vec3d(vertexJson.get("x").getAsDouble(), vertexJson.get("y").getAsDouble(), vertexJson.get("z").getAsDouble());
                }
                Preconditions.checkState((ctJson.has("connected_textures") && ctJson.get("connected_textures").isJsonArray() && ctJson.get("connected_textures").getAsJsonArray().size() == 5 ? 1 : 0) != 0, (Object)"Connected texture face must provide 5 textures");
                ResourceLocation[] textures = new ResourceLocation[5];
                JsonArray texturesArray = ctJson.get("connected_textures").getAsJsonArray();
                for (int i = 0; i < 5; ++i) {
                    textures[i] = new ResourceLocation(texturesArray.get(i).getAsString());
                }
                int tintIndex = -1;
                if (ctJson.has("tintindex")) {
                    tintIndex = ctJson.get("tintindex").getAsInt();
                }
                EnumFacing cullFace = null;
                if (ctJson.has("cullface")) {
                    cullFace = EnumFacing.func_176739_a((String)ctJson.get("cullface").getAsString());
                }
                connectedTextures.add(new ConnectedTextureQuad(textures, indices[0], indices[1], indices[2], indices[3], vertices[0], vertices[1], vertices[2], vertices[3], cullFace, tintIndex));
            }
        }
        boolean ambientOcclusion = this.ambientOcclusion;
        if (customData.containsKey((Object)"ambient_occlusion")) {
            changed = true;
            ambientOcclusion = parser.parse((String)customData.get((Object)"ambient_occlusion")).getAsBoolean();
        }
        ResourceLocation particleTexture = this.particleTexture;
        if (customData.containsKey((Object)"particle_texture")) {
            changed = true;
            particleTexture = new ResourceLocation(parser.parse((String)customData.get((Object)"particle_texture")).getAsString());
        }
        if (changed) {
            return new ModelConnectedTexture(particleTexture == null ? TextureMap.field_174945_f : particleTexture, ambientOcclusion, connectedTextures);
        }
        return this;
    }

    public static class ModelBakedConnectedFace
    implements IPerspectiveAwareModel {
        protected final ConnectedTextureQuad[][] connectedTextures;
        protected final TextureAtlasSprite particleTexture;
        protected final boolean ambientOcclusion;
        protected final VertexFormat format;
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        private ModelBakedConnectedFace(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, TextureAtlasSprite particleTexture, boolean ambientOcclusion, List<ConnectedTextureQuad> connectedTextures) {
            this.ambientOcclusion = ambientOcclusion;
            this.format = format;
            this.transforms = transforms;
            this.transformation = transformation.isPresent() ? (TRSRTransformation)transformation.get() : null;
            this.particleTexture = particleTexture;
            this.connectedTextures = new ConnectedTextureQuad[EnumFacing.field_82609_l.length + 1][];
            ArrayList<ConnectedTextureQuad> connectedTextureQuads = new ArrayList<ConnectedTextureQuad>();
            for (int i = 0; i < EnumFacing.field_82609_l.length + 1; ++i) {
                EnumFacing face = i == 0 ? null : EnumFacing.field_82609_l[i - 1];
                connectedTextureQuads.clear();
                for (ConnectedTextureQuad tex : connectedTextures) {
                    if (face != tex.cullFace) continue;
                    connectedTextureQuads.add(tex);
                }
                this.connectedTextures[i == 0 ? 0 : face.func_176745_a() + 1] = connectedTextureQuads.toArray(new ConnectedTextureQuad[0]);
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState stateOld, EnumFacing side, long rand) {
            IExtendedBlockState state = (IExtendedBlockState)stateOld;
            ImmutableMap properties = state.getUnlistedProperties();
            int faceIndex = side == null ? 0 : side.func_176745_a() + 1;
            ConnectedTextureQuad[] connectedTextures = this.connectedTextures[faceIndex];
            if (connectedTextures.length > 0) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(connectedTextures.length * 4);
                for (ConnectedTextureQuad tex : connectedTextures) {
                    int[] indices = new int[4];
                    for (Map.Entry entry : properties.entrySet()) {
                        String property = ((IUnlistedProperty)entry.getKey()).getName();
                        if (tex.index0.equals(property)) {
                            indices[0] = (Integer)((Optional)entry.getValue()).get();
                            continue;
                        }
                        if (tex.index1.equals(property)) {
                            indices[1] = (Integer)((Optional)entry.getValue()).get();
                            continue;
                        }
                        if (tex.index2.equals(property)) {
                            indices[2] = (Integer)((Optional)entry.getValue()).get();
                            continue;
                        }
                        if (!tex.index3.equals(property)) continue;
                        indices[3] = (Integer)((Optional)entry.getValue()).get();
                    }
                    for (int i = 0; i < 4; ++i) {
                        quads.add(tex.quads[i][indices[i]]);
                    }
                }
                return quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }
    }

    protected static class ConnectedTextureQuad {
        protected final ResourceLocation[] textures;
        protected final String index0;
        protected final String index1;
        protected final String index2;
        protected final String index3;
        protected final Vec3d p1;
        protected final Vec3d p2;
        protected final Vec3d p3;
        protected final Vec3d p4;
        protected final EnumFacing cullFace;
        protected final int tintIndex;
        protected final BakedQuad[][] quads;

        protected ConnectedTextureQuad(ResourceLocation[] textures, String index0, String index1, String index2, String index3, Vec3d p1, Vec3d p2, Vec3d p3, Vec3d p4, EnumFacing cullFace, int tintIndex) {
            this.textures = textures;
            this.index0 = index0;
            this.index1 = index1;
            this.index2 = index2;
            this.index3 = index3;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
            this.cullFace = cullFace;
            this.tintIndex = tintIndex;
            this.quads = new BakedQuad[4][this.textures.length];
        }

        public BakedQuad[][] getQuads() {
            return this.quads;
        }

        public void bake(Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format) {
            Vec3d p12 = this.p1.func_178787_e(this.p2).func_186678_a(0.5);
            Vec3d p23 = this.p2.func_178787_e(this.p3).func_186678_a(0.5);
            Vec3d p34 = this.p3.func_178787_e(this.p4).func_186678_a(0.5);
            Vec3d p14 = this.p4.func_178787_e(this.p1).func_186678_a(0.5);
            Vec3d cp = p12.func_178787_e(p34).func_186678_a(0.5);
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[this.textures.length];
            for (int i = 0; i < sprites.length; ++i) {
                sprites[i] = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.textures[i]);
            }
            this.quads[0] = this.bakeTextureVariants(format, transformation, sprites, this.p1, p12, cp, p14, 0);
            this.quads[1] = this.bakeTextureVariants(format, transformation, sprites, p12, this.p2, p23, cp, 2);
            this.quads[2] = this.bakeTextureVariants(format, transformation, sprites, cp, p23, this.p3, p34, 3);
            this.quads[3] = this.bakeTextureVariants(format, transformation, sprites, p14, cp, p34, this.p4, 1);
        }

        protected BakedQuad[] bakeTextureVariants(VertexFormat format, Optional<TRSRTransformation> transformation, TextureAtlasSprite[] sprites, Vec3d p1, Vec3d p2, Vec3d p3, Vec3d p4, int quadrant) {
            float umin = 0.0f;
            float vmin = 0.0f;
            float umax = 16.0f;
            float vmax = 16.0f;
            if (quadrant == 0) {
                umin = 0.0f;
                umax = 8.0f;
                vmin = 0.0f;
                vmax = 8.0f;
            } else if (quadrant == 1) {
                umin = 8.0f;
                umax = 16.0f;
                vmin = 0.0f;
                vmax = 8.0f;
            } else if (quadrant == 2) {
                umin = 0.0f;
                umax = 8.0f;
                vmin = 8.0f;
                vmax = 16.0f;
            } else if (quadrant == 3) {
                umin = 8.0f;
                umax = 16.0f;
                vmin = 8.0f;
                vmax = 16.0f;
            }
            QuadBuilder builder = new QuadBuilder(4 * this.textures.length, format);
            if (transformation.isPresent()) {
                builder.setTransformation((TRSRTransformation)transformation.get());
            }
            for (int i = 0; i < sprites.length; ++i) {
                builder.setSprite(sprites[i]);
                builder.addVertex(p1, umin, vmin);
                builder.addVertex(p2, umin, vmax);
                builder.addVertex(p3, umax, vmax);
                builder.addVertex(p4, umax, vmin);
            }
            return builder.build(b -> b.setQuadTint(this.tintIndex)).toArray(new BakedQuad[0]);
        }
    }
}

