/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class ModelCombined
implements IModelCustomData {
    private IModel baseModel;
    private IModel additionalModel;

    public ModelCombined() {
    }

    public ModelCombined(IModel baseModel, IModel additionalModel) {
        this.baseModel = baseModel;
        this.additionalModel = additionalModel;
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> dependencies = new ArrayList<ResourceLocation>();
        if (this.baseModel != null) {
            dependencies.addAll(this.baseModel.getDependencies());
        }
        if (this.additionalModel != null) {
            dependencies.addAll(this.additionalModel.getDependencies());
        }
        return dependencies;
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        if (this.baseModel != null) {
            textures.addAll(this.baseModel.getTextures());
        }
        if (this.additionalModel != null) {
            textures.addAll(this.additionalModel.getTextures());
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseBakedModel = this.baseModel.bake(state, format, bakedTextureGetter);
        IBakedModel additionalBakedModel = this.additionalModel.bake(state, format, bakedTextureGetter);
        return new BakedCombinedModel(baseBakedModel, additionalBakedModel);
    }

    public IModelState getDefaultState() {
        return this.baseModel.getDefaultState();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        IModel additionalModel;
        if (!customData.containsKey((Object)"model_base") || !customData.containsKey((Object)"model_additional")) {
            return this;
        }
        JsonParser parser = new JsonParser();
        String baseJsonStr = (String)customData.get((Object)"model_base");
        String additionalJsonStr = (String)customData.get((Object)"model_additional");
        ResourceLocation baseModelLocation = new ResourceLocation(parser.parse(baseJsonStr).getAsString());
        ResourceLocation additionalModelLocation = new ResourceLocation(parser.parse(additionalJsonStr).getAsString());
        IModel baseModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)baseModelLocation, (String)"Could not find base model for combined model");
        if (baseModel instanceof IModelCustomData) {
            if (!customData.containsKey((Object)"model_base_data")) {
                return this;
            }
            baseModel = ((IModelCustomData)baseModel).process(ModelCombined.getCustomDataFor(parser, (String)customData.get((Object)"model_base_data")));
        }
        if ((additionalModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)additionalModelLocation, (String)"Could not find additional model for combined model")) instanceof IModelCustomData) {
            if (!customData.containsKey((Object)"model_additional_data")) {
                return this;
            }
            additionalModel = ((IModelCustomData)additionalModel).process(ModelCombined.getCustomDataFor(parser, (String)customData.get((Object)"model_additional_data")));
        }
        return new ModelCombined(baseModel, additionalModel);
    }

    public static ImmutableMap<String, String> getCustomDataFor(JsonParser parser, String customData) {
        JsonElement element = parser.parse(customData);
        JsonObject jsonObj = element.getAsJsonObject();
        ImmutableMap.Builder parsedElements = ImmutableMap.builder();
        for (Map.Entry elementEntry : jsonObj.entrySet()) {
            parsedElements.put(elementEntry.getKey(), (Object)((JsonElement)elementEntry.getValue()).toString());
        }
        return parsedElements.build();
    }

    public static class BakedCombinedModel
    implements IPerspectiveAwareModel {
        private final IBakedModel baseBakedModel;
        private final IBakedModel additionalBakedModel;

        public BakedCombinedModel(IBakedModel baseBakedModel, IBakedModel additionalBakedModel) {
            this.baseBakedModel = baseBakedModel;
            this.additionalBakedModel = additionalBakedModel;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(this.baseBakedModel.func_188616_a(state, side, rand));
            quads.addAll(this.additionalBakedModel.func_188616_a(state, side, rand));
            return quads;
        }

        public boolean func_177555_b() {
            return this.baseBakedModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.baseBakedModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.baseBakedModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.baseBakedModel.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.baseBakedModel.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return this.baseBakedModel.func_188617_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair result = this.baseBakedModel instanceof IPerspectiveAwareModel ? ((IPerspectiveAwareModel)this.baseBakedModel).handlePerspective(cameraTransformType) : IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.func_177552_f().func_181688_b(cameraTransformType), (ItemCameraTransforms.TransformType)cameraTransformType);
            return Pair.of((Object)this, (Object)result.getValue());
        }
    }
}

