/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelBlank
implements IModelCustomData {
    private final ResourceLocation particleTexture;
    private final List<ResourceLocation> texturesToLoad = new ArrayList<ResourceLocation>();

    public ModelBlank() {
        this.particleTexture = null;
    }

    public ModelBlank(ResourceLocation texture) {
        if (texture == null) {
            throw new IllegalArgumentException("No particle texture specified!");
        }
        this.particleTexture = texture;
    }

    public ModelBlank(List<ResourceLocation> texturesToLoad) {
        this.texturesToLoad.addAll(texturesToLoad);
        this.particleTexture = texturesToLoad.get(0);
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptySet();
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        if (this.particleTexture != null) {
            textures.add(this.particleTexture);
        }
        if (!this.texturesToLoad.isEmpty()) {
            textures.addAll(this.texturesToLoad);
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new ModelBakedBlank((TextureAtlasSprite)bakedTextureGetter.apply((Object)this.particleTexture));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"particle_texture")) {
            throw new IllegalArgumentException("No particle texture specified!");
        }
        JsonParser parser = new JsonParser();
        ResourceLocation particleTextureLocation = new ResourceLocation(parser.parse((String)customData.get((Object)"particle_texture")).getAsString());
        return new ModelBlank(particleTextureLocation);
    }

    public static class ModelBakedBlank
    implements IBakedModel {
        private final ImmutableList<BakedQuad> noQuads = ImmutableList.of();
        private final TextureAtlasSprite particleTexture;

        public ModelBakedBlank(TextureAtlasSprite particleTexture) {
            this.particleTexture = particleTexture;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return this.noQuads;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

