/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.model.entity.ModelWight;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.mobs.EntityWight;

public class RenderWight
extends RenderLiving<EntityWight> {
    private final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/entity/wight.png");
    private static final ModelWight MODEL = new ModelWight();
    private static final ModelWight MODEL_HEAD_ONLY = new ModelWight().setRenderHeadOnly(true);

    public RenderWight(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)MODEL, 0.5f);
    }

    protected ResourceLocation getEntityTexture(EntityWight entity) {
        return this.texture;
    }

    protected void preRenderCallback(EntityWight entity, float partialTickTime) {
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 10.0f, -1.0f, -1.0f, -1.0f));
        }
        GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
        if (entity.isVolatile()) {
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)0.0);
        }
    }

    public void doRender(EntityWight entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!entity.isVolatile()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179084_k();
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - entity.getHidingAnimation(partialTicks) * 0.5f));
            super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
            GlStateManager.func_179121_F();
        } else {
            this.field_77045_g = MODEL_HEAD_ONLY;
            GlStateManager.func_179094_E();
            GlStateManager.func_179084_k();
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (entity.func_184187_bx() != null) {
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179091_B();
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(((float)entity.field_70173_aa + partialTicks) / 30.0f * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)((double)(-entity.func_184187_bx().func_70047_e()) + 1.65), (double)0.8);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                this.func_180548_c((Entity)entity);
                MODEL_HEAD_ONLY.func_78088_a((Entity)entity, 0.0f, 0.0f, (float)entity.field_70173_aa + partialTicks, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                MODEL_HEAD_ONLY.func_78088_a((Entity)entity, 0.0f, 0.0f, (float)entity.field_70173_aa + partialTicks, 0.0f, 0.0f, 0.0625f);
            } else {
                super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
            }
            GlStateManager.func_179121_F();
            this.field_77045_g = MODEL;
        }
    }
}

