/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.entity.ParticleGasCloud;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.mobs.EntityGasCloud;

@SideOnly(value=Side.CLIENT)
public class RenderGasCloud
extends Render<EntityGasCloud> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/particle/gas_cloud.png");

    public RenderGasCloud(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityGasCloud entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179092_a((int)516, (float)0.004f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            GlStateManager.func_179144_i((int)ShaderHelper.INSTANCE.getWorldShader().getGasTexture());
        } else {
            this.func_110776_a(TEXTURE);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        this.renderGasParticles(buffer, entity, partialTicks);
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.getWorldShader().getGasParticleBuffer().bind();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            this.renderGasParticles(buffer, entity, partialTicks);
            tessellator.func_78381_a();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179145_e();
    }

    private void renderGasParticles(VertexBuffer buffer, EntityGasCloud entity, float partialTicks) {
        for (Object obj : entity.gasParticles) {
            ParticleGasCloud particle = (ParticleGasCloud)obj;
            if (!entity.func_70089_S()) {
                int[] gasColor = entity.getGasColor();
                float fade = 1.0f - (float)entity.field_70725_aQ / 80.0f;
                particle.func_82338_g((float)Math.pow(fade, 2.0) * (float)gasColor[3] / 255.0f);
                particle.func_70538_b((float)gasColor[0] / 255.0f * fade, (float)gasColor[1] / 255.0f * fade, (float)gasColor[2] / 255.0f * fade);
            }
            particle.renderParticleFullTexture(buffer, (Entity)Minecraft.func_71410_x().field_71439_g, partialTicks, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178809_c(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f());
        }
    }

    protected ResourceLocation getEntityTexture(EntityGasCloud entity) {
        return null;
    }
}

