/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.model.entity.ModelFortressBoss;
import thebetweenlands.client.render.model.entity.ModelSwordEnergy;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.WorldShader;
import thebetweenlands.common.entity.mobs.EntityFortressBoss;
import thebetweenlands.util.LightingUtil;

public class RenderFortressBoss
extends Render<EntityFortressBoss> {
    private static double[][] vertices = EntityFortressBoss.ICOSAHEDRON_VERTICES;
    private static int[][] indices = EntityFortressBoss.ICOSAHEDRON_INDICES;
    private static final ResourceLocation SHIELD_TEXTURE = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private static final ModelSwordEnergy BULLET_MODEL = new ModelSwordEnergy();
    private static final ResourceLocation MODEL_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/fortress_boss.png");
    private static final ModelFortressBoss MODEL = new ModelFortressBoss();

    public RenderFortressBoss(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityFortressBoss entity, double x, double y, double z, float yaw, float partialTicks) {
        double len;
        int i;
        EntityFortressBoss boss = entity;
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            WorldShader shader = ShaderHelper.INSTANCE.getWorldShader();
            if (boss.field_70172_ad == 0) {
                float lightIntensity = 0.0f;
                for (int i2 = 0; i2 <= 19; ++i2) {
                    float shieldAnimationTicks = (float)boss.shieldAnimationTicks[i2] - 1.0f + partialTicks;
                    if (!(shieldAnimationTicks > 0.0f) || !(shieldAnimationTicks <= 20.0f)) continue;
                    lightIntensity += shieldAnimationTicks / 20.0f * 2.0f;
                }
                if (lightIntensity > 0.0f) {
                    ShaderHelper.INSTANCE.require();
                    shader.addLight(new LightSource(boss.field_70165_t, boss.field_70163_u, boss.field_70161_v, 16.0f, 0.85f * MathHelper.func_76131_a((float)lightIntensity, (float)0.0f, (float)4.0f), 0.0f * MathHelper.func_76131_a((float)lightIntensity, (float)0.0f, (float)4.0f), 0.9f * MathHelper.func_76131_a((float)lightIntensity, (float)0.0f, (float)4.0f)));
                }
            } else {
                ShaderHelper.INSTANCE.require();
                shader.addLight(new LightSource(boss.field_70165_t, boss.field_70163_u, boss.field_70161_v, 16.0f, 1.5f / (float)boss.field_70771_an * ((float)boss.field_70172_ad + partialTicks), 0.0f, 0.0f));
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        GlStateManager.func_179137_b((double)x, (double)(y + (boss.coreBoundingBox.field_72337_e - boss.coreBoundingBox.field_72338_b) / 2.0 + 0.15), (double)z);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_110776_a(MODEL_TEXTURE);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.2, (double)0.0);
        GlStateManager.func_179137_b((double)(Math.sin((double)((float)entity.field_70173_aa + partialTicks) / 5.0) * (double)0.1f), (double)(Math.cos((double)((float)entity.field_70173_aa + partialTicks) / 7.0) * (double)0.1f), (double)(Math.cos((double)((float)entity.field_70173_aa + partialTicks) / 6.0) * (double)0.1f));
        GlStateManager.func_179152_a((float)0.55f, (float)0.55f, (float)0.55f);
        GlStateManager.func_179129_p();
        LightingUtil.INSTANCE.setLighting(255);
        MODEL.func_78088_a((Entity)entity, entity.field_70140_Q, 360.0f, (float)entity.field_70173_aa + partialTicks, 0.0f, 0.0f, 0.065f);
        LightingUtil.INSTANCE.revert();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.0), (double)(y + 1.0), (double)(z + 0.0));
        GlStateManager.func_179114_b((float)boss.getShieldRotationPitch(partialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)boss.getShieldRotationYaw(partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)boss.getShieldRotationRoll(partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        LightingUtil.INSTANCE.setLighting(255);
        double explode = boss.getShieldExplosion(partialTicks);
        float ticks = (float)entity.field_70173_aa + partialTicks;
        this.func_110776_a(SHIELD_TEXTURE);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179094_E();
        float uOffset = ticks * 0.01f % 1.0f;
        float vOffset = ticks * 0.01f % 1.0f;
        GlStateManager.func_179109_b((float)uOffset, (float)vOffset, (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        for (i = 0; i <= 19; ++i) {
            float a;
            float b;
            float g;
            float r;
            if (!boss.isShieldActive(i)) continue;
            float shieldAnimationTicks = (float)boss.shieldAnimationTicks[i] - 1.0f + partialTicks;
            if (shieldAnimationTicks > 0.0f && shieldAnimationTicks <= 20.0f) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                r = 0.05f * shieldAnimationTicks;
                g = 0.5f - 0.025f * shieldAnimationTicks;
                b = 1.0f - 0.05f * shieldAnimationTicks;
                a = 1.0f;
            } else if (shieldAnimationTicks > 20.0f && shieldAnimationTicks <= 40.0f) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                r = 0.4f;
                g = 1.0f;
                b = 1.0f - 0.044999998f * (shieldAnimationTicks - 20.0f);
                a = 0.95f;
            } else {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                r = 0.4f;
                g = 0.8f;
                b = 0.9f;
                a = 0.25f;
            }
            double[] v3 = vertices[indices[i][0]];
            double[] v2 = vertices[indices[i][1]];
            double[] v1 = vertices[indices[i][2]];
            double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
            double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
            double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
            double len2 = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
            double textureScale = 4.0;
            double cu = textureScale / 2.0;
            double cv = textureScale * Math.sqrt(2.0) / 2.0;
            int layers = 8;
            buffer.func_181668_a(4, DefaultVertexFormats.field_181709_i);
            for (int l = 0; l < (shieldAnimationTicks > 0.0f && shieldAnimationTicks <= 20.0f ? 4 : layers); ++l) {
                double cos = Math.cos(Math.PI * 2 / (double)layers * (double)l);
                double sin = 1.0 + Math.sin(Math.PI * 2 / (double)layers * (double)l);
                double tu1 = 0.0 - cu;
                double tv1 = 0.0 - cv;
                double tu2 = textureScale / 2.0 / (double)layers * (double)l - cu;
                double tv2 = textureScale / (double)layers * (double)l * Math.sqrt(2.0) - cv;
                double tu3 = textureScale / (double)layers * (double)l - cu;
                double tv3 = 0.0 - cv;
                tu1 = cu + tu1 * sin;
                tv1 = cv + tv1 * cos;
                tu2 = cu + tu2 * sin;
                tv2 = cv + tv2 * cos;
                tu3 = cu + tu3 * sin;
                tv3 = cv + tv3 * cos;
                buffer.func_181662_b(v1[0] + centerX / len2 * explode, v1[1] + centerY / len2 * explode, v1[2] + centerZ / len2 * explode).func_187315_a(tu1, tv1).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b(v2[0] + centerX / len2 * explode, v2[1] + centerY / len2 * explode, v2[2] + centerZ / len2 * explode).func_187315_a(tu2, tv2).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b(v3[0] + centerX / len2 * explode, v3[1] + centerY / len2 * explode, v3[2] + centerZ / len2 * explode).func_187315_a(tu3, tv3).func_181666_a(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179090_x();
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= 19; ++i) {
            if (!boss.isShieldActive(i)) continue;
            double[] v3 = vertices[indices[i][0]];
            double[] v2 = vertices[indices[i][1]];
            double[] v1 = vertices[indices[i][2]];
            double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
            double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
            double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
            len = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
            buffer.func_181662_b(v1[0] + centerX / len * explode, v1[1] + centerY / len * explode, v1[2] + centerZ / len * explode).func_181666_a(0.5f, 0.6f, 1.0f, 0.5f).func_181675_d();
            buffer.func_181662_b(v2[0] + centerX / len * explode, v2[1] + centerY / len * explode, v2[2] + centerZ / len * explode).func_181666_a(0.5f, 0.6f, 1.0f, 0.5f).func_181675_d();
            buffer.func_181662_b(v3[0] + centerX / len * explode, v3[1] + centerY / len * explode, v3[2] + centerZ / len * explode).func_181666_a(0.5f, 0.6f, 1.0f, 0.5f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int p = 0; p < 2; ++p) {
            if (p == 1) {
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
                GlStateManager.func_179132_a((boolean)false);
            }
            buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
            for (int i3 = 0; i3 <= 19; ++i3) {
                if (!boss.isShieldActive(i3)) continue;
                double[] v3 = vertices[indices[i3][0]];
                double[] v2 = vertices[indices[i3][1]];
                double[] v1 = vertices[indices[i3][2]];
                double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
                double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
                double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
                double len3 = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
                double a = len3 + explode;
                Vec3d center = new Vec3d(centerX, centerY, centerZ);
                Vec3d vert1 = new Vec3d(v1[0], v1[1], v1[2]);
                double b = vert1.func_72430_b(center);
                double d = a * Math.tan(b);
                double vertexExplode = Math.sqrt(a * a + d * d) - 1.0;
                Vec3d v1Normalized = new Vec3d(v1[0], v1[1], v1[2]).func_72432_b();
                Vec3d v2Normalized = new Vec3d(v2[0], v2[1], v2[2]).func_72432_b();
                Vec3d v3Normalized = new Vec3d(v3[0], v3[1], v3[2]).func_72432_b();
                buffer.func_181662_b(v1[0] + v1Normalized.field_72450_a * vertexExplode, v1[1] + v1Normalized.field_72448_b * vertexExplode, v1[2] + v1Normalized.field_72449_c * vertexExplode).func_181666_a(0.05f, 0.05f, 0.05f, 0.45f).func_181675_d();
                buffer.func_181662_b(v2[0] + v2Normalized.field_72450_a * vertexExplode, v2[1] + v2Normalized.field_72448_b * vertexExplode, v2[2] + v2Normalized.field_72449_c * vertexExplode).func_181666_a(0.05f, 0.05f, 0.05f, 0.45f).func_181675_d();
                buffer.func_181662_b(v3[0] + v3Normalized.field_72450_a * vertexExplode, v3[1] + v3Normalized.field_72448_b * vertexExplode, v3[2] + v3Normalized.field_72449_c * vertexExplode).func_181666_a(0.05f, 0.05f, 0.05f, 0.45f).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (this.func_177068_d().func_178634_b()) {
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= 19; ++i) {
                if (!boss.isShieldActive(i)) continue;
                double[] v3 = vertices[indices[i][0]];
                double[] v2 = vertices[indices[i][1]];
                double[] v1 = vertices[indices[i][2]];
                double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
                double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
                double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
                len = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
                Vec3d vec1 = new Vec3d(v1[0] + centerX / len * explode, v1[1] + centerY / len * explode, v1[2] + centerZ / len * explode);
                Vec3d vec2 = new Vec3d(v2[0] + centerX / len * explode, v2[1] + centerY / len * explode, v2[2] + centerZ / len * explode);
                Vec3d vec3 = new Vec3d(v3[0] + centerX / len * explode, v3[1] + centerY / len * explode, v3[2] + centerZ / len * explode);
                Vec3d normal = vec2.func_178788_d(vec1).func_72431_c(vec3.func_178788_d(vec1));
                buffer.func_181662_b(centerX + centerX / len * explode, centerY + centerY / len * explode, centerZ + centerZ / len * explode).func_181666_a(0.8f, 0.0f, 1.0f, 0.5f).func_181675_d();
                buffer.func_181662_b(normal.field_72450_a + centerX + centerX / len * explode, normal.field_72448_b + centerY + centerY / len * explode, normal.field_72449_c + centerZ + centerZ / len * explode).func_181666_a(0.8f, 0.0f, 1.0f, 0.5f).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)1.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= 19; ++i) {
            if (!boss.isShieldActive(i)) continue;
            double[] v3 = vertices[indices[i][0]];
            double[] v2 = vertices[indices[i][1]];
            double[] v1 = vertices[indices[i][2]];
            double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
            double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
            double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
            len = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
            buffer.func_181662_b(v1[0] + centerX / len * explode, v1[1] + centerY / len * explode, v1[2] + centerZ / len * explode).func_181666_a(0.5f, 0.75f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(v2[0] + centerX / len * explode, v2[1] + centerY / len * explode, v2[2] + centerZ / len * explode).func_181666_a(0.5f, 0.75f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(v2[0] + centerX / len * explode, v2[1] + centerY / len * explode, v2[2] + centerZ / len * explode).func_181666_a(0.5f, 0.75f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(v3[0] + centerX / len * explode, v3[1] + centerY / len * explode, v3[2] + centerZ / len * explode).func_181666_a(0.5f, 0.75f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(v3[0] + centerX / len * explode, v3[1] + centerY / len * explode, v3[2] + centerZ / len * explode).func_181666_a(0.5f, 0.75f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(v1[0] + centerX / len * explode, v1[1] + centerY / len * explode, v1[2] + centerZ / len * explode).func_181666_a(0.5f, 0.75f, 1.0f, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)2848);
        if (this.func_177068_d().func_178634_b()) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179129_p();
            Vec3d pos = Minecraft.func_71410_x().field_71439_g.func_174824_e(partialTicks);
            Vec3d ray = Minecraft.func_71410_x().field_71439_g.func_70676_i(partialTicks);
            ray = ray.func_186678_a(64.0);
            int hitShield = boss.rayTraceShield(pos, ray, false);
            if (hitShield >= 0) {
                double[] v3 = vertices[indices[hitShield][0]];
                double[] v2 = vertices[indices[hitShield][1]];
                double[] v1 = vertices[indices[hitShield][2]];
                double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
                double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
                double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
                double len4 = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
                Vec3d vec1 = new Vec3d(v1[0] + centerX / len4 * explode, v1[1] + centerY / len4 * explode, v1[2] + centerZ / len4 * explode);
                Vec3d vec2 = new Vec3d(v2[0] + centerX / len4 * explode, v2[1] + centerY / len4 * explode, v2[2] + centerZ / len4 * explode);
                Vec3d vec3 = new Vec3d(v3[0] + centerX / len4 * explode, v3[1] + centerY / len4 * explode, v3[2] + centerZ / len4 * explode);
                vec1 = vec1.func_72441_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                vec2 = vec2.func_72441_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                vec3 = vec3.func_72441_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(v1[0] + centerX / len4 * explode, v1[1] + centerY / len4 * explode, v1[2] + centerZ / len4 * explode).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_181662_b(v2[0] + centerX / len4 * explode, v2[1] + centerY / len4 * explode, v2[2] + centerZ / len4 * explode).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_181662_b(v3[0] + centerX / len4 * explode, v3[1] + centerY / len4 * explode, v3[2] + centerZ / len4 * explode).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                tessellator.func_78381_a();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        GlStateManager.func_179121_F();
        if (boss.getGroundAttackTicks() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y - 2.8), (double)z);
            GlStateManager.func_179098_w();
            this.func_110776_a(SHIELD_TEXTURE);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float interpTicks = ticks + partialTicks;
            float uOffsetAttack = interpTicks * 0.01f;
            float vOffsetAttack = interpTicks * 0.01f;
            GlStateManager.func_179109_b((float)uOffsetAttack, (float)vOffsetAttack, (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179139_a((double)3.8, (double)3.8, (double)3.8);
            GlStateManager.func_179131_c((float)(0.04f * (float)boss.getGroundAttackTicks()), (float)(0.030000001f * (float)boss.getGroundAttackTicks()), (float)(0.02f * (float)boss.getGroundAttackTicks()), (float)1.0f);
            BULLET_MODEL.render(0.0625f);
            GlStateManager.func_179089_o();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        LightingUtil.INSTANCE.revert();
        GlStateManager.func_179145_e();
        GL11.glDisable((int)2848);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179098_w();
    }

    protected ResourceLocation getEntityTexture(EntityFortressBoss entity) {
        return null;
    }
}

