/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import java.util.AbstractMap;
import java.util.Random;
import javax.vecmath.Vector3d;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.WorldRenderHandler;
import thebetweenlands.client.render.entity.layer.LayerGlow;
import thebetweenlands.client.render.model.entity.ModelFirefly;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.mobs.EntityFirefly;

@SideOnly(value=Side.CLIENT)
public class RenderFirefly
extends RenderLiving<EntityFirefly> {
    public static final ResourceLocation GLOW_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/firefly_glow.png");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/firefly.png");
    public static final ResourceLocation TEXTURE_OVERLAY = new ResourceLocation("thebetweenlands:textures/entity/firefly_glow_overlay.png");
    protected static final Random RANDOM = new Random();
    protected final LayerGlow<EntityFirefly> glow = new LayerGlow(this, TEXTURE_OVERLAY);

    public RenderFirefly(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelFirefly(), 0.0f);
        this.func_177094_a(this.glow);
    }

    public void doRender(EntityFirefly entity, double x, double y, double z, float yaw, float partialTicks) {
        float radius;
        double glowStrength = (float)entity.func_110148_a(EntityFirefly.GLOW_STRENGTH_ATTRIB).func_111126_e();
        this.glow.setAlpha(entity.getGlowTicks(partialTicks) / 20.0f * (float)Math.min(glowStrength, 1.0));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)(Math.sin(((float)entity.field_70173_aa + partialTicks) / 10.0f) * (double)0.15f), (double)0.0);
        super.func_76986_a((EntityLiving)entity, x, y, z, yaw, partialTicks);
        GlStateManager.func_179121_F();
        WorldRenderHandler.fireflies.add(new AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<RenderFirefly, EntityFirefly>, Vector3d>(new AbstractMap.SimpleEntry<RenderFirefly, EntityFirefly>(this, entity), new Vector3d(x, y, z)));
        if (ShaderHelper.INSTANCE.isWorldShaderActive() && (radius = entity.getGlowTicks(partialTicks) / 20.0f * 7.0f * (float)glowStrength) > 0.1f) {
            double interpX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double interpY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks - 0.5;
            double interpZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            ShaderHelper.INSTANCE.require();
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(interpX, interpY, interpZ, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + radius, 3.7647061f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f, 2.8235295f + entity.field_70170_p.field_73012_v.nextFloat() * 0.1f, 1.8823531f));
        }
    }

    public void renderFireflyGlow(EntityFirefly entity, double x, double y, double z, float partialTicks) {
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        this.func_110776_a(GLOW_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float rx = ActiveRenderInfo.func_178808_b();
        float rxz = ActiveRenderInfo.func_178809_c();
        float rz = ActiveRenderInfo.func_178803_d();
        float ryz = ActiveRenderInfo.func_178805_e();
        float rxy = ActiveRenderInfo.func_178807_f();
        double ipx = x;
        double ipy = y + 0.25 + Math.sin(((float)entity.field_70173_aa + partialTicks) / 10.0f) * (double)0.15f;
        double ipz = z;
        double glowStrength = (float)entity.func_110148_a(EntityFirefly.GLOW_STRENGTH_ATTRIB).func_111126_e();
        double scale = (double)(entity.getGlowTicks(partialTicks) / 20.0f) * glowStrength;
        float red = 0.4f;
        float green = 0.2f;
        float blue = 0.0f;
        float alpha = 0.2f;
        if (RANDOM.nextInt(10) <= 2) {
            red = (float)RANDOM.nextInt(10) / 20.0f + 0.25f;
        }
        double currentScale = scale;
        for (i = 0; i < (RANDOM.nextInt(10) <= 2 ? RANDOM.nextInt(10) : 10); ++i) {
            buffer.func_181662_b(ipx - (double)rx * (currentScale -= scale * 0.15) - (double)ryz * currentScale, ipy - (double)rxz * currentScale, ipz - (double)rz * currentScale - (double)rxy * currentScale).func_187315_a(0.0, 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(ipx - (double)rx * currentScale + (double)ryz * currentScale, ipy + (double)rxz * currentScale, ipz - (double)rz * currentScale + (double)rxy * currentScale).func_187315_a(1.0, 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(ipx + (double)rx * currentScale + (double)ryz * currentScale, ipy + (double)rxz * currentScale, ipz + (double)rz * currentScale + (double)rxy * currentScale).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(ipx + (double)rx * currentScale - (double)ryz * currentScale, ipy - (double)rxz * currentScale, ipz + (double)rz * currentScale - (double)rxy * currentScale).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        red = 0.6f;
        green = 0.6f;
        blue = 0.6f;
        currentScale = scale / 4.0;
        for (i = 0; i < 10; ++i) {
            buffer.func_181662_b(ipx - (double)rx * (currentScale -= scale * 0.15 / 4.0) - (double)ryz * currentScale, ipy - (double)rxz * currentScale, ipz - (double)rz * currentScale - (double)rxy * currentScale).func_187315_a(0.0, 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(ipx - (double)rx * currentScale + (double)ryz * currentScale, ipy + (double)rxz * currentScale, ipz - (double)rz * currentScale + (double)rxy * currentScale).func_187315_a(1.0, 1.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(ipx + (double)rx * currentScale + (double)ryz * currentScale, ipy + (double)rxz * currentScale, ipz + (double)rz * currentScale + (double)rxy * currentScale).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(ipx + (double)rx * currentScale - (double)ryz * currentScale, ipy - (double)rxz * currentScale, ipz + (double)rz * currentScale - (double)rxy * currentScale).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    protected ResourceLocation getEntityTexture(EntityFirefly entity) {
        return TEXTURE;
    }
}

