/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.entity.layer.LayerGlow;
import thebetweenlands.client.render.model.entity.ModelAngler;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.mobs.EntityAngler;

@SideOnly(value=Side.CLIENT)
public class RenderAngler
extends RenderLiving<EntityAngler> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/angler.png");

    public RenderAngler(RenderManager manager) {
        super(manager, (ModelBase)new ModelAngler(), 0.5f);
        this.func_177094_a(new LayerGlow(this, new ResourceLocation("thebetweenlands:textures/entity/angler_glow.png")));
    }

    protected ResourceLocation getEntityTexture(EntityAngler entity) {
        return TEXTURE;
    }

    protected void preRenderCallback(EntityAngler entity, float f) {
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        if (entity.isGrounded() && !entity.isLeaping()) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.7f, (float)0.7f, (float)0.0f);
        }
    }

    public void doRender(EntityAngler entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            double rx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double ry = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double rz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            double xOff = Math.sin(Math.toRadians(-entity.field_70761_aq)) * (double)0.3f;
            double zOff = Math.cos(Math.toRadians(-entity.field_70761_aq)) * (double)0.3f;
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(rx + xOff, ry + (double)0.95f, rz + zOff, 2.6f, 1.5294118f, 4.5882354f, 3.0588236f));
        }
    }
}

