/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3d;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.entity.RenderFirefly;
import thebetweenlands.client.render.particle.entity.ParticleWisp;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.tile.RenderWisp;
import thebetweenlands.common.block.terrain.BlockWisp;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityWisp;

public class WorldRenderHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    public static final List<Pair<Pair<RenderWisp, TileEntityWisp>, Vec3d>> WISP_TILE_LIST = new ArrayList<Pair<Pair<RenderWisp, TileEntityWisp>, Vec3d>>();
    public static final List<Map.Entry<Map.Entry<RenderFirefly, EntityFirefly>, Vector3d>> fireflies = new ArrayList<Map.Entry<Map.Entry<RenderFirefly, EntityFirefly>, Vector3d>>();
    private static float partialTicks;

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        }
    }

    public static float getPartialTicks() {
        return partialTicks;
    }

    @SubscribeEvent
    public static void renderWorld(RenderWorldLastEvent event) {
        Object renderer;
        double renderViewX = WorldRenderHandler.MC.func_175598_ae().field_78730_l;
        double renderViewY = WorldRenderHandler.MC.func_175598_ae().field_78731_m;
        double renderViewZ = WorldRenderHandler.MC.func_175598_ae().field_78728_n;
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179092_a((int)516, (float)0.004f);
        MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int prevMinFilter = GL11.glGetTexParameteri((int)3553, (int)10241);
        int prevMagFilter = GL11.glGetTexParameteri((int)3553, (int)10240);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        for (Pair<Pair<RenderWisp, TileEntityWisp>, Vec3d> pair : WISP_TILE_LIST) {
            TileEntityWisp te = (TileEntityWisp)((Object)((Pair)pair.getKey()).getValue());
            renderer = (RenderWisp)((Object)((Pair)pair.getKey()).getKey());
            Vec3d pos = (Vec3d)pair.getValue();
            IBlockState blockState = te.func_145831_w().func_180495_p(te.func_174877_v());
            if (blockState.func_177230_c() != BlockRegistry.WISP) continue;
            ((RenderWisp)((Object)renderer)).renderWispParticles(vertexBuffer, te, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, event.getPartialTicks());
            double rx = pos.field_72450_a + renderViewX + 0.5;
            double ry = pos.field_72448_b + renderViewY + 0.5;
            double rz = pos.field_72449_c + renderViewZ + 0.5;
            float size = 3.0f;
            if (!BlockWisp.canSee(te.func_145831_w(), te.func_174877_v())) {
                size = (1.0f - MathHelper.func_76126_a((float)(0.19634955f * MathHelper.func_76131_a((float)ParticleWisp.getDistanceToViewer(rx, ry, rz, event.getPartialTicks()), (float)10.0f, (float)20.0f)))) * 1.2f;
            }
            int colorIndex = (Integer)blockState.func_177229_b((IProperty)BlockWisp.COLOR);
            for (int i = 0; i < 2; ++i) {
                int color = BlockWisp.COLORS[colorIndex * 2 + i];
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                if (!ShaderHelper.INSTANCE.isWorldShaderActive()) continue;
                ShaderHelper.INSTANCE.require();
                ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(rx, ry, rz, i == 0 ? size : size * 0.5f, r * (i == 0 ? 3.5f : 1.0f), g * (i == 0 ? 3.5f : 1.0f), b * (i == 0 ? 3.5f : 1.0f)));
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179094_E();
        for (Map.Entry entry : fireflies) {
            Vector3d pos = (Vector3d)entry.getValue();
            renderer = (RenderFirefly)((Object)((Map.Entry)entry.getKey()).getKey());
            EntityFirefly entity = (EntityFirefly)((Map.Entry)entry.getKey()).getValue();
            ((RenderFirefly)((Object)renderer)).renderFireflyGlow(entity, pos.x, pos.y, pos.z, event.getPartialTicks());
        }
        GlStateManager.func_179121_F();
        fireflies.clear();
        MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)prevMinFilter);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)prevMagFilter);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        WISP_TILE_LIST.clear();
    }
}

