/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.lang.reflect.Method;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thebetweenlands.api.event.PreRenderShadersEvent;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.util.config.ConfigHandler;

public class ShaderHandler {
    public static final ShaderHandler INSTANCE = new ShaderHandler();
    private final Method methodRenderHand = ReflectionHelper.findMethod(EntityRenderer.class, null, (String[])new String[]{"renderHand", "func_78476_b", "b"}, (Class[])new Class[]{Float.TYPE, Integer.TYPE});
    private final Method methodSetupCameraTransform = ReflectionHelper.findMethod(EntityRenderer.class, null, (String[])new String[]{"setupCameraTransform", "func_78479_a", "a"}, (Class[])new Class[]{Float.TYPE, Integer.TYPE});
    private boolean cancelOverlays = false;

    @SubscribeEvent
    public void onPreRenderShaders(PreRenderShadersEvent event) {
        if (ShaderHelper.INSTANCE.canUseShaders()) {
            ShaderHelper.INSTANCE.renderShaders(event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPreRenderWorld(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (ShaderHelper.INSTANCE.isShaderSupported() && ConfigHandler.useShader) {
                Framebuffer framebuffer = mc.func_147110_a();
                if (!mc.field_71474_y.field_151448_g) {
                    mc.field_71474_y.field_151448_g = true;
                    framebuffer.func_147613_a(mc.field_71443_c, mc.field_71440_d);
                }
                if (ShaderHelper.INSTANCE.isHDRActive()) {
                    int colorFormat;
                    int n = ShaderHelper.INSTANCE.isFloatBufferSupported() ? 34842 : (colorFormat = ShaderHelper.INSTANCE.isARBFloatBufferSupported() ? 34843 : -1);
                    if (colorFormat != -1) {
                        GlStateManager.func_179144_i((int)framebuffer.field_147617_g);
                        GlStateManager.func_187419_a((int)3553, (int)0, (int)colorFormat, (int)framebuffer.field_147622_a, (int)framebuffer.field_147620_b, (int)0, (int)6408, (int)5126, (IntBuffer)null);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (ShaderHelper.INSTANCE.canUseShaders()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.cancelOverlays = true;
            try {
                this.methodRenderHand.invoke((Object)Minecraft.func_71410_x().field_71460_t, Float.valueOf(event.getPartialTicks()), MinecraftForgeClient.getRenderPass());
                this.methodSetupCameraTransform.invoke((Object)Minecraft.func_71410_x().field_71460_t, Float.valueOf(event.getPartialTicks()), MinecraftForgeClient.getRenderPass());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.cancelOverlays = false;
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179121_F();
            ShaderHelper.INSTANCE.updateShaders(event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        if (this.cancelOverlays && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(this.cancelOverlays);
        }
    }

    @SubscribeEvent
    public void onPostRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && ShaderHelper.INSTANCE.getWorldShader() != null) {
            ShaderHelper.INSTANCE.getWorldShader().clearLights();
        }
    }
}

