/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.book.widgets.text.FormatTags;
import thebetweenlands.common.herblore.book.widgets.text.TextContainer;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;
import thebetweenlands.util.AspectIconRenderer;
import thebetweenlands.util.ColorUtils;
import thebetweenlands.util.config.ConfigHandler;

public class ScreenRenderHandler
extends Gui {
    public static ScreenRenderHandler INSTANCE = new ScreenRenderHandler();
    private static final ResourceLocation DECAY_BAR_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/decay_bar.png");
    private Random random = new Random();
    private int updateCounter;
    private TextContainer titleContainer = null;
    private String currentLocation = "";
    private int titleTicks = 0;
    private int maxTitleTicks = 120;
    public static final ResourceLocation TITLE_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/location_title.png");
    public static final DecimalFormat ASPECT_AMOUNT_FORMAT = new DecimalFormat("#.##");

    private ScreenRenderHandler() {
    }

    public static List<LocationStorage> getVisibleLocations(Entity entity) {
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(entity.field_70170_p);
        return worldStorage.getSharedStorageAt(LocationStorage.class, location -> location.isInside(entity.func_174824_e(1.0f)) && location.isVisible(entity), entity.field_70165_t, entity.field_70161_v);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().func_147113_T()) {
            EntityPlayerSP player;
            ++this.updateCounter;
            if (this.titleTicks > 0) {
                --this.titleTicks;
            }
            if ((player = Minecraft.func_71410_x().field_71439_g) != null && player.field_71093_bK == ConfigHandler.dimensionId) {
                String prevLocation = this.currentLocation;
                List<LocationStorage> locations = ScreenRenderHandler.getVisibleLocations((Entity)player);
                if (locations.isEmpty()) {
                    String location;
                    Object strippedName;
                    if (player.field_70163_u < 100.0) {
                        strippedName = I18n.func_135052_a((String)"location.wilderness.name", (Object[])new Object[0]);
                        if (((String)strippedName).startsWith("translate:")) {
                            int startIndex = ((String)strippedName).indexOf("translate:");
                            strippedName = ((String)strippedName).substring(startIndex + 1, ((String)strippedName).length());
                        }
                        if (this.currentLocation.equals(strippedName)) {
                            prevLocation = "";
                        }
                        location = I18n.func_135052_a((String)"location.caverns.name", (Object[])new Object[0]);
                    } else {
                        strippedName = I18n.func_135052_a((String)"location.caverns.name", (Object[])new Object[0]);
                        if (((String)strippedName).startsWith("translate:")) {
                            int startIndex = ((String)strippedName).indexOf("translate:");
                            strippedName = ((String)strippedName).substring(startIndex + 1, ((String)strippedName).length());
                        }
                        if (this.currentLocation.equals(strippedName)) {
                            prevLocation = "";
                        }
                        location = I18n.func_135052_a((String)"location.wilderness.name", (Object[])new Object[0]);
                    }
                    this.currentLocation = location;
                } else {
                    LocationStorage highestLocation = null;
                    for (LocationStorage storage : locations) {
                        if (highestLocation != null && storage.getLayer() <= highestLocation.getLayer()) continue;
                        highestLocation = storage;
                    }
                    this.currentLocation = highestLocation.getLocalizedName();
                }
                if (this.currentLocation.length() > 0) {
                    if (this.currentLocation.contains(":")) {
                        int startIndex = this.currentLocation.indexOf(":");
                        try {
                            String ticks = this.currentLocation.substring(0, startIndex);
                            this.maxTitleTicks = Integer.parseInt(ticks);
                            this.currentLocation = this.currentLocation.substring(startIndex + 1, this.currentLocation.length());
                        }
                        catch (Exception ex) {
                            this.maxTitleTicks = 80;
                        }
                    }
                    if (prevLocation != null && !prevLocation.equals(this.currentLocation)) {
                        this.titleTicks = this.maxTitleTicks;
                        this.titleContainer = new TextContainer(2048.0, 2048.0, this.currentLocation, TheBetweenlands.proxy.getCustomFontRenderer());
                        this.titleContainer.setCurrentScale(2.0f).setCurrentColor(-1);
                        this.titleContainer.registerTag(new FormatTags.TagNewLine());
                        this.titleContainer.registerTag(new FormatTags.TagScale(2.0f));
                        this.titleContainer.registerTag(new FormatTags.TagSimple("bold", TextFormatting.BOLD));
                        this.titleContainer.registerTag(new FormatTags.TagSimple("obfuscated", TextFormatting.OBFUSCATED));
                        this.titleContainer.registerTag(new FormatTags.TagSimple("italic", TextFormatting.ITALIC));
                        this.titleContainer.registerTag(new FormatTags.TagSimple("strikethrough", TextFormatting.STRIKETHROUGH));
                        this.titleContainer.registerTag(new FormatTags.TagSimple("underline", TextFormatting.UNDERLINE));
                        try {
                            this.titleContainer.parse();
                        }
                        catch (Exception e) {
                            this.titleContainer = null;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null) {
                Object capability;
                if (player.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
                    capability = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
                    int yOffset = 0;
                    for (EnumEquipmentInventory type : EnumEquipmentInventory.values()) {
                        IInventory inv = capability.getInventory(type);
                        int posX = width / 2 + 93;
                        int posY = height + yOffset - 19;
                        boolean hadItem = false;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack stack = inv.func_70301_a(i);
                            if (stack == null) continue;
                            float scale = 1.0f;
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)posX, (float)posY, (float)0.0f);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.func_179147_l();
                            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                            mc.func_175599_af().func_180450_b(stack, 0, 0);
                            mc.func_175599_af().func_180453_a(mc.field_71466_p, stack, 0, 0, null);
                            GlStateManager.func_179118_c();
                            GlStateManager.func_179101_C();
                            GlStateManager.func_179140_f();
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.func_179147_l();
                            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                            GlStateManager.func_179098_w();
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.func_179121_F();
                            posX += 8;
                            hadItem = true;
                        }
                        if (!hadItem) continue;
                        yOffset -= 13;
                    }
                }
                if (!player.func_184218_aH() && player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null) && (capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)).isDecayEnabled()) {
                    Entity ridingEntity;
                    int duration;
                    int startX = width / 2 - 13 + 23;
                    int startY = height - 49;
                    if (player.getEntityData().func_74764_b("antivenomDuration") && (duration = player.getEntityData().func_74762_e("antivenomDuration")) > 0) {
                        startY -= 12;
                    }
                    if (TheBetweenlands.isToughAsNailsModInstalled) {
                        startY -= 10;
                    }
                    if ((ridingEntity = player.func_184187_bx()) != null && ridingEntity instanceof EntityLivingBase) {
                        EntityLivingBase riddenEntity = (EntityLivingBase)ridingEntity;
                        float maxEntityHealth = riddenEntity.func_110138_aP();
                        int maxHealthHearts = (int)(maxEntityHealth + 0.5f) / 2;
                        if (maxHealthHearts > 30) {
                            maxHealthHearts = 30;
                        }
                        int guiOffsetY = 0;
                        while (maxHealthHearts > 0) {
                            int renderedHearts = Math.min(maxHealthHearts, 10);
                            maxHealthHearts -= renderedHearts;
                            guiOffsetY -= 10;
                        }
                        startY += guiOffsetY + 10;
                    }
                    int decay = 20 - capability.getDecayStats().getDecayLevel();
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(DECAY_BAR_TEXTURE);
                    for (int i = 0; i < 10; ++i) {
                        int offsetY;
                        int n = offsetY = player.func_70055_a(Material.field_151586_h) ? -10 : 0;
                        if (this.updateCounter % (decay * 3 + 1) == 0) {
                            offsetY += this.random.nextInt(3) - 1;
                        }
                        GlStateManager.func_179147_l();
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.func_73729_b(startX + 71 - i * 8, startY + offsetY, 18, 0, 9, 9);
                        if (i * 2 + 1 < decay) {
                            this.func_73729_b(startX + 71 - i * 8, startY + offsetY, 0, 0, 9, 9);
                        }
                        if (i * 2 + 1 != decay) continue;
                        this.func_73729_b(startX + 72 - i * 8, startY + offsetY, 9, 0, 9, 9);
                    }
                }
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && this.titleTicks > 0 && this.titleContainer != null && !this.titleContainer.getPages().isEmpty()) {
            TextContainer.TextPage page = this.titleContainer.getPages().get(0);
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            double strWidth = page.getTextWidth();
            double strHeight = page.getTextHeight();
            double strX = (double)width / 2.0 - strWidth / 2.0;
            double strY = (double)height / 5.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)strX, (double)strY, (double)0.0);
            float fade = Math.min(1.0f, ((float)this.maxTitleTicks - (float)this.titleTicks) / Math.min(40.0f, (float)this.maxTitleTicks - 5.0f) + 0.02f) - Math.max(0.0f, (float)(-this.titleTicks + 5) / 5.0f);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179147_l();
            float averageScale = 0.0f;
            for (TextContainer.TextSegment segment : page.getSegments()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)segment.x, (double)segment.y, (double)0.0);
                GlStateManager.func_179152_a((float)segment.scale, (float)segment.scale, (float)1.0f);
                float[] rgba = ColorUtils.getRGBA(segment.color);
                segment.font.func_78276_b(segment.text, 0, 0, ColorUtils.toHex(rgba[0], rgba[1], rgba[2], rgba[3] * fade));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                averageScale += segment.scale;
            }
            averageScale /= (float)page.getSegments().size();
            GlStateManager.func_179121_F();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TITLE_TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)fade);
            GlStateManager.func_179129_p();
            double sidePadding = 6.0;
            double yOffset = 5.0;
            double sy = Math.ceil(strY + strHeight - yOffset * (double)averageScale);
            double ey = Math.ceil(strY + strHeight + (-yOffset + 16.0) * (double)averageScale);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.renderTexturedRect(buffer, strX - sidePadding * (double)averageScale, sy, strX - sidePadding * (double)averageScale + (double)(9.0f * averageScale), ey, 0.0, 0.0703125, 0.0, 1.0);
            this.renderTexturedRect(buffer, strX - sidePadding * (double)averageScale + (double)(9.0f * averageScale), sy, strX + strWidth / 2.0 - (double)(6.0f * averageScale), ey, 0.0703125, 0.453125, 0.0, 1.0);
            this.renderTexturedRect(buffer, strX + strWidth / 2.0 - (double)(6.0f * averageScale), sy, strX + strWidth / 2.0 + (double)(6.0f * averageScale), ey, 0.453125, 0.546875, 0.0, 1.0);
            this.renderTexturedRect(buffer, strX + strWidth / 2.0 + (double)(6.0f * averageScale), sy, strX + strWidth + sidePadding * (double)averageScale - (double)(9.0f * averageScale), ey, 0.546875, 0.9296875, 0.0, 1.0);
            this.renderTexturedRect(buffer, strX + strWidth + sidePadding * (double)averageScale - (double)(9.0f * averageScale), sy, strX + strWidth + sidePadding * (double)averageScale, ey, 0.9296875, 1.0, 0.0, 1.0);
            tessellator.func_78381_a();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    private void renderTexturedRect(VertexBuffer buffer, double x, double y, double x2, double y2, double umin, double umax, double vmin, double vmax) {
        buffer.func_181662_b(x, y2, 0.0).func_187315_a(umin, vmax).func_181675_d();
        buffer.func_181662_b(x2, y2, 0.0).func_187315_a(umax, vmax).func_181675_d();
        buffer.func_181662_b(x2, y, 0.0).func_187315_a(umax, vmin).func_181675_d();
        buffer.func_181662_b(x, y, 0.0).func_187315_a(umin, vmin).func_181675_d();
    }

    @SubscribeEvent
    public void onRenderScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainer container;
        Slot selectedSlot;
        Minecraft mc = Minecraft.func_71410_x();
        if (Keyboard.isKeyDown((int)42) && mc.field_71462_r instanceof GuiContainer && mc.field_71439_g != null && (selectedSlot = (container = (GuiContainer)mc.field_71462_r).getSlotUnderMouse()) != null && selectedSlot.func_75216_d()) {
            ScaledResolution resolution = new ScaledResolution(mc);
            FontRenderer fontRenderer = mc.field_71466_p;
            double mouseX = (double)Mouse.getX() * resolution.func_78327_c() / (double)mc.field_71443_c;
            double mouseY = resolution.func_78324_d() - (double)Mouse.getY() * resolution.func_78324_d() / (double)mc.field_71440_d - 1.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(mouseX + 8.0), (double)(mouseY - 38.0), (double)500.0);
            int yOffset = 0;
            int width = 0;
            List<Aspect> aspects = ItemAspectContainer.fromItem(selectedSlot.func_75211_c(), AspectManager.get((World)mc.field_71441_e)).getAspects((EntityPlayer)mc.field_71439_g);
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
            if (aspects != null && aspects.size() > 0) {
                for (Aspect aspect : aspects) {
                    String aspectText = aspect.type.getName() + " (" + ASPECT_AMOUNT_FORMAT.format(aspect.getDisplayAmount()) + ")";
                    String aspectTypeText = aspect.type.getType();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    fontRenderer.func_78276_b(aspectText, 19, 2 + yOffset, -1);
                    fontRenderer.func_78276_b(aspectTypeText, 19, 11 + yOffset, -1);
                    AspectIconRenderer.renderIcon(2, 2 + yOffset, 16, 16, aspect.type.getIcon());
                    int entryWidth = Math.max(fontRenderer.func_78256_a(aspectText) + 19, fontRenderer.func_78256_a(aspectTypeText) + 19);
                    if (entryWidth > width) {
                        width = entryWidth;
                    }
                    yOffset -= 21;
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
                Gui.func_73734_a((int)0, (int)(yOffset + 20), (int)(width + 1), (int)21, (int)-1879048192);
                Gui.func_73734_a((int)1, (int)(yOffset + 21), (int)width, (int)20, (int)-1442840576);
            }
            RenderHelper.func_74520_c();
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

