/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.config.ConfigHandler;

public class MusicHandler {
    public static final MusicHandler INSTANCE = new MusicHandler();
    private static final Field f_accessorList = ReflectionHelper.findField(SoundEventAccessor.class, (String[])new String[]{"accessorList", "a", "field_188716_a"});
    private static final int MIN_WAIT = 6000;
    private static final int MAX_WAIT = 12000;
    private List<Sound> musicTrackAccessors;
    private Minecraft mc = Minecraft.func_71410_x();
    private final Random RNG = new Random();
    private int timeUntilMusic = 100;
    private ISound currentSound;
    private Sound previousSound;

    private MusicHandler() {
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        EntityPlayer player = this.getPlayer();
        if (player != null && player.field_71093_bK == ConfigHandler.dimensionId && this.mc.field_71474_y.func_186711_a(SoundCategory.MUSIC) > 0.0f) {
            if (this.currentSound != null) {
                if (!this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                    this.currentSound = null;
                    this.timeUntilMusic = Math.min(MathHelper.func_76136_a((Random)this.RNG, (int)6000, (int)12000), this.timeUntilMusic);
                }
            } else if (this.timeUntilMusic-- <= 0) {
                this.timeUntilMusic = MathHelper.func_76136_a((Random)this.RNG, (int)6000, (int)12000);
                this.playRandomSoundTrack();
            }
        }
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        EntityPlayer player = this.getPlayer();
        if (player != null && player.field_71093_bK == ConfigHandler.dimensionId && event.getSound().func_184365_d() == SoundCategory.MUSIC && !this.isBetweenlandsMusic(event.getSound())) {
            event.setResultSound(null);
        }
    }

    public boolean isBetweenlandsMusic(ISound sound) {
        if (SoundRegistry.BL_MUSIC_DIMENSION.func_187503_a().equals((Object)sound.func_147650_b())) {
            return true;
        }
        List<Sound> betweenlandsSoundTracks = this.getBetweenlandsMusicTracks();
        for (Sound blSound : betweenlandsSoundTracks) {
            if (!blSound.func_188719_a().equals((Object)sound.func_147650_b())) continue;
            return true;
        }
        return false;
    }

    public List<Sound> getBetweenlandsMusicTracks() {
        if (this.musicTrackAccessors == null) {
            try {
                this.musicTrackAccessors = new ArrayList<Sound>();
                List soundAccessors = (List)f_accessorList.get(this.mc.func_147118_V().func_184398_a(SoundRegistry.BL_MUSIC_DIMENSION.func_187503_a()));
                for (ISoundEventAccessor accessor : soundAccessors) {
                    if (!(accessor instanceof Sound)) continue;
                    this.musicTrackAccessors.add((Sound)accessor);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.musicTrackAccessors;
    }

    public void playRandomSoundTrack() {
        ArrayList<Sound> availableSounds = new ArrayList<Sound>(this.getBetweenlandsMusicTracks());
        if (!availableSounds.isEmpty()) {
            if (availableSounds.size() > 1 && this.previousSound != null) {
                availableSounds.remove(this.previousSound);
            }
            int weight = 0;
            for (Sound sound : availableSounds) {
                weight += sound.func_148721_a();
            }
            if (weight != 0) {
                ISound playingSound;
                Sound sound;
                int choice = this.RNG.nextInt(weight);
                Iterator entryIter = availableSounds.iterator();
                while ((choice -= (sound = (Sound)entryIter.next()).func_148721_a()) >= 0) {
                }
                this.previousSound = sound;
                PositionedSoundRecord parentSound = PositionedSoundRecord.func_184370_a((SoundEvent)SoundRegistry.BL_MUSIC_DIMENSION);
                this.currentSound = playingSound = SoundWrapper.wrap((ISound)parentSound, sound);
                this.mc.func_147118_V().func_147682_a(playingSound);
            }
        }
    }

    private EntityPlayer getPlayer() {
        return this.mc.field_71439_g;
    }

    protected static class SoundWrapperTickable
    extends SoundWrapper
    implements ITickableSound {
        private final ITickableSound parent;

        private SoundWrapperTickable(ITickableSound parent, Sound sound) {
            super((ISound)parent, sound);
            this.parent = parent;
        }

        public void func_73660_a() {
            this.parent.func_73660_a();
        }

        public boolean func_147667_k() {
            return this.parent.func_147667_k();
        }
    }

    public static class SoundWrapper
    implements ISound {
        private final ISound parent;
        private final Sound sound;

        private SoundWrapper(ISound parent, Sound sound) {
            this.parent = parent;
            this.sound = sound;
        }

        public static ISound wrap(ISound parent, Sound sound) {
            if (parent instanceof ITickableSound) {
                return new SoundWrapperTickable((ITickableSound)parent, sound);
            }
            return new SoundWrapper(parent, sound);
        }

        public ResourceLocation func_147650_b() {
            return this.sound.func_188719_a();
        }

        public SoundEventAccessor func_184366_a(SoundHandler handler) {
            SoundEventAccessor parentAccessor = this.parent.func_184366_a(handler);
            ITextComponent subtitle = parentAccessor != null ? parentAccessor.func_188712_c() : null;
            SoundEventAccessor accessor = new SoundEventAccessor(this.sound.func_188719_a(), subtitle != null ? subtitle.func_150254_d() : null);
            return accessor;
        }

        public Sound func_184364_b() {
            return this.sound;
        }

        public SoundCategory func_184365_d() {
            return this.parent.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.parent.func_147657_c();
        }

        public int func_147652_d() {
            return this.parent.func_147652_d();
        }

        public float func_147653_e() {
            return this.sound.func_188724_c();
        }

        public float func_147655_f() {
            return this.sound.func_188725_d();
        }

        public float func_147649_g() {
            return this.parent.func_147649_g();
        }

        public float func_147654_h() {
            return this.parent.func_147654_h();
        }

        public float func_147651_i() {
            return this.parent.func_147651_i();
        }

        public ISound.AttenuationType func_147656_j() {
            return this.parent.func_147656_j();
        }
    }
}

