/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.capability.IFoodSicknessCapability;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.api.item.IFoodSicknessItem;
import thebetweenlands.api.recipes.ICompostBinRecipe;
import thebetweenlands.client.handler.ScreenRenderHandler;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.recipe.misc.CompostRecipe;
import thebetweenlands.common.registries.CapabilityRegistry;

public class ItemTooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        EntityPlayerSP player;
        CircleGemType circleGem;
        ItemStack stack = event.getItemStack();
        List toolTip = event.getToolTip();
        ICompostBinRecipe recipe = CompostRecipe.getCompostRecipe(stack);
        if (recipe != null) {
            String debug = "";
            if (event.isShowAdvancedItemTooltips()) {
                debug = " (T: " + ScreenRenderHandler.ASPECT_AMOUNT_FORMAT.format((float)recipe.getCompostingTime(stack) / 20.0f) + "s A: " + recipe.getCompostAmount(stack) + ")";
            }
            toolTip.add(I18n.func_135052_a((String)"tooltip.compost.compostable", (Object[])new Object[0]) + debug);
        }
        if ((circleGem = CircleGemHelper.getGem(stack)) != CircleGemType.NONE) {
            toolTip.add(I18n.func_135052_a((String)("tooltip.circlegem." + circleGem.name), (Object[])new Object[0]));
        }
        if (stack.func_77973_b() instanceof ItemFood && stack.func_77973_b() instanceof IFoodSicknessItem && ((IFoodSicknessItem)stack.func_77973_b()).canGetSickOf(stack) && (player = TheBetweenlands.proxy.getClientPlayer()) != null && player.hasCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null)) {
            IFoodSicknessCapability cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null);
            FoodSickness sickness = cap.getSickness((ItemFood)stack.func_77973_b());
            int hatred = cap.getFoodHatred((ItemFood)stack.func_77973_b());
            ((IFoodSicknessItem)stack.func_77973_b()).getSicknessTooltip(stack, sickness, hatred, event.isShowAdvancedItemTooltips(), toolTip);
        }
        player = Minecraft.func_71410_x().field_71439_g;
        if (stack.func_77973_b() instanceof IEquippable && player != null && ((IEquippable)stack.func_77973_b()).canEquip(stack, (EntityPlayer)player, (Entity)player)) {
            toolTip.add(I18n.func_135052_a((String)"tooltip.item.equippable", (Object[])new Object[0]));
        }
    }

    public static List<String> splitTooltip(String tooltip, int indent) {
        String indentStr = new String(new char[indent]).replace('\u0000', ' ');
        ArrayList<String> lines = new ArrayList<String>();
        String[] splits = tooltip.split("\\\\n");
        for (int i = 0; i < splits.length; ++i) {
            splits[i] = indentStr + splits[i];
        }
        lines.addAll(Arrays.asList(splits));
        return lines;
    }
}

