/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.UpdateFogEvent;
import thebetweenlands.api.misc.Fog;
import thebetweenlands.api.misc.FogState;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;
import thebetweenlands.common.world.storage.world.shared.location.LocationAmbience;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;
import thebetweenlands.util.FogGenerator;
import thebetweenlands.util.config.ConfigHandler;

public class FogHandler {
    private static FogState state = new FogState();
    private static float currentFogStart = -1.0f;
    private static float currentFogEnd = -1.0f;
    private static float farPlaneDistance = 0.0f;
    private static int fogMode;
    private static FogGenerator fogGenerator;

    private FogHandler() {
    }

    public static FogState getFogState() {
        return state;
    }

    public static float getCurrentFogStart() {
        return currentFogStart;
    }

    public static float getCurrentFogEnd() {
        return currentFogEnd;
    }

    public static int getCurrentFogMode() {
        return fogMode;
    }

    public static boolean hasDenseFog() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.field_73011_w instanceof WorldProviderBetweenlands && Minecraft.func_71410_x().field_71439_g.field_70163_u > 110.0) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
            EnvironmentEventRegistry eeRegistry = provider.getWorldData().getEnvironmentEventRegistry();
            if (eeRegistry.DENSE_FOG.isActive()) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFogRenderEvent(EntityViewRenderEvent.RenderFogEvent event) {
        farPlaneDistance = event.getFarPlaneDistance();
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (renderView != null && renderView.field_71093_bK == ConfigHandler.dimensionId) {
            float partialTicks = (float)event.getRenderPartialTicks();
            Fog fog = state.getFog(partialTicks);
            float fogStart = currentFogStart = fog.getStart();
            float fogEnd = currentFogEnd = fog.getEnd();
            fogMode = fog.getGlFogType();
            switch (fog.getFogType()) {
                default: {
                    GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
                    break;
                }
                case EXP: {
                    GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                    GlStateManager.func_179095_a((float)fog.getDensity());
                    break;
                }
                case EXP2: {
                    GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
                    GlStateManager.func_179095_a((float)fog.getDensity());
                }
            }
            GlStateManager.func_179102_b((float)fogStart);
            GlStateManager.func_179153_c((float)fogEnd);
        } else {
            currentFogStart = farPlaneDistance * 0.75f;
            currentFogEnd = farPlaneDistance;
            fogMode = 9729;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        World world = TheBetweenlands.proxy.getClientWorld();
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (world != null && player != null) {
            Biome biome;
            if (farPlaneDistance != 0.0f && player.field_71093_bK == ConfigHandler.dimensionId) {
                state.update(world, player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), farPlaneDistance, 0);
            }
            if ((biome = world.getBiomeForCoordsBody(player.func_180425_c())) instanceof BiomeBetweenlands) {
                ((BiomeBetweenlands)biome).updateFog();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (renderView != null) {
            IBlockState blockState = ActiveRenderInfo.func_186703_a((World)renderView.field_70170_p, (Entity)renderView, (float)((float)event.getRenderPartialTicks()));
            Fog fog = state.getFog((float)event.getRenderPartialTicks());
            float fogColorMultiplier = fog.getColorMultiplier();
            if (blockState.func_177230_c() instanceof BlockSwampWater) {
                BlockPos pos = new BlockPos(ActiveRenderInfo.func_178806_a((Entity)renderView, (double)((float)event.getRenderPartialTicks())));
                int colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(blockState, (IBlockAccess)renderView.field_70170_p, pos, 0);
                if (renderView.field_71093_bK == ConfigHandler.dimensionId) {
                    double waterFogColorMultiplier = fogColorMultiplier / 2.0f;
                    event.setRed((float)(colorMultiplier >> 16 & 0xFF) / 255.0f * (float)waterFogColorMultiplier);
                    event.setGreen((float)(colorMultiplier >> 8 & 0xFF) / 255.0f * (float)waterFogColorMultiplier);
                    event.setBlue((float)(colorMultiplier & 0xFF) / 255.0f * (float)waterFogColorMultiplier);
                } else {
                    event.setRed((float)(colorMultiplier >> 16 & 0xFF) / 255.0f);
                    event.setGreen((float)(colorMultiplier >> 8 & 0xFF) / 255.0f);
                    event.setBlue((float)(colorMultiplier & 0xFF) / 255.0f);
                }
            } else if (renderView.field_71093_bK == ConfigHandler.dimensionId) {
                WorldProviderBetweenlands provider = (WorldProviderBetweenlands)renderView.func_130014_f_().field_73011_w;
                Vec3d fogColor = provider.func_76562_b(renderView.func_130014_f_().func_72826_c((float)event.getRenderPartialTicks()), (float)event.getRenderPartialTicks());
                event.setRed((float)fogColor.field_72450_a);
                event.setGreen((float)fogColor.field_72448_b);
                event.setBlue((float)fogColor.field_72449_c);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        Block block;
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (renderView != null && (block = ActiveRenderInfo.func_186703_a((World)renderView.field_70170_p, (Entity)renderView, (float)((float)event.getRenderPartialTicks())).func_177230_c()) instanceof BlockSwampWater) {
            fogMode = 2048;
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            if (renderView instanceof EntityLivingBase && ((EntityLivingBase)renderView).func_70644_a(Potion.func_188412_a((int)13))) {
                event.setDensity(0.1f);
            } else {
                event.setDensity(0.4f);
            }
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void updateFog(UpdateFogEvent event) {
        Object[] color;
        LocationAmbience ambience;
        Vec3d position = event.getPosition();
        World world = event.getWorld();
        FogState state = event.getFogState();
        Fog biomeFog = event.getBiomeFog();
        Fog.MutableFog fog = new Fog.MutableFog(event.getAmbientFog());
        float fogBrightness = 0.0f;
        if (FogHandler.hasDenseFog()) {
            if (fogGenerator == null || fogGenerator.getSeed() != Minecraft.func_71410_x().field_71441_e.func_72905_C()) {
                fogGenerator = new FogGenerator(Minecraft.func_71410_x().field_71441_e.func_72905_C());
            }
            float lowViewDistanceFogReduction = state.getLowDistanceFogReduction(biomeFog.getEnd());
            float[] range = fogGenerator.getFogRange(0.2f, 1.0f);
            float denseFogStart = 0.0f;
            float denseFogEnd = state.getFixedFogEnd(biomeFog.getEnd()) / Math.max(3.0f * lowViewDistanceFogReduction, 1.0f) * range[1];
            fog.setStart(Math.min(fog.getStart(), denseFogStart));
            fog.setEnd(Math.min(fog.getEnd(), denseFogEnd));
            int transitionStart = 110;
            int transitionEnd = 95;
            float y = (float)event.getPosition().field_72448_b;
            if (y < 110.0f) {
                if (95.0f < y) {
                    fogBrightness = (y - 95.0f) / 15.0f * 80.0f;
                }
            } else {
                fogBrightness = 80.0f;
            }
        }
        if ((ambience = LocationStorage.getAmbience(world, position)) != null) {
            if (ambience.hasFogBrightness()) {
                fogBrightness = ambience.getFogBrightness();
            }
            if (ambience.hasFogColor()) {
                color = ambience.getFogColor();
                fog.setRed((float)color[0] / 255.0f).setGreen((float)color[1] / 255.0f).setBlue((float)color[2] / 255.0f);
            }
            if (ambience.hasFogColorMultiplier()) {
                fog.setColorMultiplier(ambience.getFogColorMultiplier());
            }
            if (ambience.hasFogRange()) {
                fog.setStart(ambience.getFogStart());
                fog.setEnd(ambience.getFogEnd());
            }
            if (ambience.hasFogRangeMultiplier()) {
                fog.setStart(fog.getStart() * ambience.getFogRangeMultiplier());
                fog.setStart(fog.getEnd() * ambience.getFogRangeMultiplier());
            }
        }
        if (WorldProviderBetweenlands.getProvider((World)world).getEnvironmentEventRegistry().BLOODSKY.isActive()) {
            if (!ShaderHelper.INSTANCE.isWorldShaderActive()) {
                fog.setRed(0.74f).setGreen(0.18f).setBlue(0.08f);
            } else {
                fogBrightness = 0.0f;
            }
        } else if (WorldProviderBetweenlands.getProvider((World)world).getEnvironmentEventRegistry().SPOOPY.isActive()) {
            if (!ShaderHelper.INSTANCE.isWorldShaderActive()) {
                fog.setRed(0.4f).setGreen(0.22f).setBlue(0.08f);
            } else {
                fogBrightness = 0.0f;
            }
        }
        color = new float[]{fog.getRed(), fog.getGreen(), fog.getBlue()};
        for (int i = 0; i < 3; ++i) {
            float diff = 1.0f - color[i];
            color[i] = color[i] + diff * fogBrightness / 255.0f;
        }
        fog.setRed(color[0]).setGreen(color[1]).setBlue(color[2]);
        state.setTargetFog(fog);
    }
}

