/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.client.audio.DruidAltarSound;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityDruidAltar;

public class DruidAltarSoundHandler {
    private static Map<TileEntityDruidAltar, DruidAltarSound> playingSounds = new HashMap<TileEntityDruidAltar, DruidAltarSound>();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        World world;
        if (event.phase == TickEvent.Phase.START && (world = TheBetweenlands.proxy.getClientWorld()) != null && !Minecraft.func_71410_x().func_147113_T()) {
            Iterator<Map.Entry<TileEntityDruidAltar, DruidAltarSound>> it = playingSounds.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TileEntityDruidAltar, DruidAltarSound> sound = it.next();
                if (!sound.getValue().func_147667_k()) continue;
                it.remove();
            }
        }
    }

    public static void playAltarSound(TileEntityDruidAltar altar) {
        if (!playingSounds.containsKey((Object)altar)) {
            DruidAltarSound sound = new DruidAltarSound(SoundRegistry.DRUID_CHANT, SoundCategory.BLOCKS, altar);
            playingSounds.put(altar, sound);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        }
    }

    public static void stopAltarSound(TileEntityDruidAltar altar) {
        DruidAltarSound sound = playingSounds.get((Object)altar);
        if (sound != null && !sound.isStopping()) {
            sound.stop();
        }
    }
}

