/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.RenderHelper;

public class DecayRenderHandler {
    public static final ResourceLocation PLAYER_DECAY_TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/player_decay.png");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        IDecayCapability capability;
        EntityPlayer player = event.getEntityPlayer();
        if (player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null) && (capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)).isDecayEnabled() && capability.getDecayStats().getDecayLevel() > 0 && !RenderHelper.doesRendererHaveLayer(event.getRenderer(), LayerDecay.class, false)) {
            event.getRenderer().func_177094_a((LayerRenderer)new LayerDecay((RenderLivingBase<AbstractClientPlayer>)event.getRenderer()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderHand(RenderSpecificHandEvent event) {
        IDecayCapability capability;
        GlStateManager.func_179094_E();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null) && (capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)).isDecayEnabled() && capability.getDecayStats().getDecayLevel() > 0) {
            boolean isMainHand;
            int decay = capability.getDecayStats().getDecayLevel();
            boolean bl = isMainHand = event.getHand() == EnumHand.MAIN_HAND;
            if (isMainHand && !player.func_82150_aj() && event.getItemStack() == null) {
                EnumHandSide enumhandside = isMainHand ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
                DecayRenderHandler.renderArmFirstPersonWithDecay(event.getEquipProgress(), event.getSwingProgress(), enumhandside, decay);
                event.setCanceled(true);
            }
        }
        GlStateManager.func_179121_F();
    }

    private static void renderArmFirstPersonWithDecay(float swingProgress, float equipProgress, EnumHandSide handSide, int decay) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        boolean flag = handSide != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)equipProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(equipProgress * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + swingProgress * -0.6f), (float)(f4 + -0.71999997f));
        GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(equipProgress * equipProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        EntityPlayerSP abstractclientplayer = mc.field_71439_g;
        mc.func_110434_K().func_110577_a(abstractclientplayer.func_110306_p());
        GlStateManager.func_179109_b((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        RenderPlayer renderplayer = (RenderPlayer)renderManager.func_78713_a((Entity)abstractclientplayer);
        GlStateManager.func_179129_p();
        if (flag) {
            renderplayer.func_177138_b((AbstractClientPlayer)abstractclientplayer);
            mc.field_71446_o.func_110577_a(PLAYER_DECAY_TEXTURE);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            float glow = (float)((Math.cos((double)abstractclientplayer.field_70173_aa / 10.0) + 1.0) / 2.0) * 0.15f;
            float transparency = 0.85f * (float)decay / 20.0f - glow;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            ModelPlayer modelplayer = renderplayer.func_177087_b();
            GlStateManager.func_179147_l();
            modelplayer.field_78095_p = 0.0f;
            modelplayer.field_78117_n = false;
            modelplayer.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)abstractclientplayer);
            modelplayer.field_178723_h.field_78795_f = 0.0f;
            modelplayer.field_178723_h.func_78785_a(0.0625f);
            modelplayer.field_178732_b.field_78795_f = 0.0f;
            modelplayer.field_178732_b.func_78785_a(0.0625f);
            GlStateManager.func_179084_k();
        } else {
            renderplayer.func_177139_c((AbstractClientPlayer)abstractclientplayer);
            mc.field_71446_o.func_110577_a(PLAYER_DECAY_TEXTURE);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            float glow = (float)((Math.cos((double)abstractclientplayer.field_70173_aa / 10.0) + 1.0) / 2.0) * 0.15f;
            float transparency = 0.85f * (float)decay / 20.0f - glow;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            ModelPlayer modelplayer = renderplayer.func_177087_b();
            GlStateManager.func_179147_l();
            modelplayer.field_78117_n = false;
            modelplayer.field_78095_p = 0.0f;
            modelplayer.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)abstractclientplayer);
            modelplayer.field_178724_i.field_78795_f = 0.0f;
            modelplayer.field_178724_i.func_78785_a(0.0625f);
            modelplayer.field_178734_a.field_78795_f = 0.0f;
            modelplayer.field_178734_a.func_78785_a(0.0625f);
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179089_o();
    }

    public static class LayerDecay
    implements LayerRenderer<AbstractClientPlayer> {
        private final RenderLivingBase<AbstractClientPlayer> renderer;
        private final Predicate<ModelRenderer> modelExclusions;

        public LayerDecay(RenderLivingBase<AbstractClientPlayer> renderer, Predicate<ModelRenderer> modelExclusions) {
            this.renderer = renderer;
            this.modelExclusions = modelExclusions;
        }

        public LayerDecay(RenderLivingBase<AbstractClientPlayer> renderer) {
            this(renderer, box -> {
                if (renderer instanceof RenderPlayer) {
                    RenderPlayer renderPlayer = (RenderPlayer)renderer;
                    ModelPlayer playerModel = renderPlayer.func_177087_b();
                    return box == playerModel.field_178720_f || box == playerModel.field_178731_d || box == playerModel.field_178733_c || box == playerModel.field_178730_v || box == playerModel.field_178732_b || box == playerModel.field_178734_a;
                }
                return false;
            });
        }

        public void doRenderLayer(AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            int decay;
            IDecayCapability cap;
            if (player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null) && (cap = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)).isDecayEnabled() && (decay = cap.getDecayStats().getDecayLevel()) > 0) {
                ModelBase model = this.renderer.func_177087_b();
                HashMap<ModelRenderer, Boolean> visibilities = new HashMap<ModelRenderer, Boolean>();
                for (ModelRenderer box : model.field_78092_r) {
                    if (!this.modelExclusions.test(box)) continue;
                    visibilities.put(box, box.field_78806_j);
                    box.field_78806_j = false;
                }
                float glow = (float)((Math.cos((double)player.field_70173_aa / 10.0) + 1.0) / 2.0) * 0.15f;
                float transparency = 0.85f * (float)decay / 20.0f - glow;
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.renderer.func_110776_a(PLAYER_DECAY_TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                model.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (Map.Entry entry : visibilities.entrySet()) {
                    ((ModelRenderer)entry.getKey()).field_78806_j = (Boolean)entry.getValue();
                }
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

