/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.common.inventory.container.ContainerAnimator;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityAnimator;

@SideOnly(value=Side.CLIENT)
public class GuiAnimator
extends GuiContainer {
    private final ResourceLocation GUI_ANIMATOR = new ResourceLocation("thebetweenlands:textures/gui/animator.png");
    private final TileEntityAnimator tile;
    private EntityPlayer playerSent;
    private int updateTicks = 0;

    public GuiAnimator(EntityPlayer player, TileEntityAnimator tile) {
        super((Container)new ContainerAnimator(player.field_71071_by, tile));
        this.tile = tile;
        this.field_146291_p = false;
        this.field_146999_f = 174;
        this.field_147000_g = 164;
        this.playerSent = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void func_146979_b(int x, int y) {
    }

    protected void func_146976_a(float partialTickTime, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.GUI_ANIMATOR);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isCrystalInslot()) {
            int lifeCrystalCount = (int)(40.0f - (float)this.tile.lifeCrystalLife / 3.0f);
            this.func_73729_b(k + 39, l + 8 + lifeCrystalCount, 175, 2 + lifeCrystalCount, 6, 42);
            if (this.tile.isValidFocalItem()) {
                int requiredLifeCrystal = this.tile.requiredLifeCount / 3;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)0.1f, (float)0.1f, (float)(0.35f + (float)(Math.cos(((float)this.updateTicks + partialTickTime) / 10.0f) + 1.0) / 2.0f * 0.65f));
                this.func_73729_b(k + 39, l + 8 + lifeCrystalCount, 175, 2 + lifeCrystalCount, 6, requiredLifeCrystal);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
            }
        }
        if (this.tile.isSlotInUse(0) && this.tile.isCrystalInslot() && this.tile.isSulfurInslot() && this.tile.fuelConsumed < this.tile.requiredFuelCount && this.tile.lifeCrystalLife >= this.tile.requiredLifeCount && this.tile.isValidFocalItem()) {
            int fuelBurnProgress = this.tile.fuelBurnProgress;
            this.func_73729_b(k + 129, l + 8 + fuelBurnProgress, 175, 2 + fuelBurnProgress, 6, 42);
            double relTotalProgress = ((double)this.tile.fuelConsumed + (double)this.tile.fuelBurnProgress / 42.0) / (double)this.tile.requiredFuelCount;
            if (relTotalProgress <= 0.66) {
                int barWidth = (int)(relTotalProgress / 0.66 * 32.0);
                this.func_73729_b(k + 51, l + 65, 182, 18, barWidth, 2);
                this.func_73729_b(k + 123 - barWidth, l + 65, 254 - barWidth, 18, barWidth, 2);
            }
            if (relTotalProgress > 0.66 && relTotalProgress <= 1.0) {
                int barHeight = (int)((relTotalProgress - 0.66) / 0.4 * 19.0);
                this.func_73729_b(k + 51, l + 65 - barHeight, 182, 18 - barHeight, 72, 2 + barHeight);
            }
        }
        if (this.tile.func_70301_a(1) == null) {
            this.renderSlot(new ItemStack(ItemRegistry.LIFE_CRYSTAL, 1, 0), k + 34, l + 57);
        }
        if (this.tile.func_70301_a(2) == null) {
            this.renderSlot(ItemMisc.EnumItemMisc.SULFUR.create(1), k + 124, l + 57);
        }
    }

    private void renderSlot(ItemStack stack, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
        GL11.glBlendFunc((int)32771, (int)32772);
        GlStateManager.func_179094_E();
        this.field_146296_j.func_180450_b(stack, x, y);
        GlStateManager.func_179121_F();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        IAnimatorRecipe recipe;
        super.func_73876_c();
        boolean shouldClose = false;
        ItemStack input = this.tile.func_70301_a(0);
        if (input != null && (recipe = AnimatorRecipe.getRecipe(input)) != null) {
            shouldClose = recipe.getCloseOnFinish(input);
        }
        if (this.tile.itemAnimated && shouldClose) {
            this.playerSent.func_71053_j();
        }
        ++this.updateTicks;
    }
}

