/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.realms.RealmsBridge;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.gui.GuiButtonMainMenu;
import thebetweenlands.client.gui.GuiFirefly;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.Starfield;
import thebetweenlands.util.config.ConfigHandler;

public class GuiBLMainMenu
extends GuiMainMenu {
    public static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("thebetweenlands", "textures/gui/main/logo.png");
    public static final int LAYER_COUNT = 4;
    private List<List<GuiFirefly>> fireFlies;
    private ResourceLocation[] layerTextures = new ResourceLocation[4];
    private int layerTick;
    private Random random = new Random();
    private Starfield starfieldEffect;
    private Framebuffer starfieldTextureFBO = null;
    private GuiButton realmsButton;
    private GuiButton modButton;
    private NotificationModUpdateScreen modUpdateNotification;

    @SubscribeEvent
    public static void onGuiOpened(GuiOpenEvent event) {
        if (ConfigHandler.blMainMenu && event.getGui() instanceof GuiMainMenu && !(event.getGui() instanceof GuiBLMainMenu)) {
            event.setGui((GuiScreen)new GuiBLMainMenu());
        }
    }

    public void func_73866_w_() {
        if (this.fireFlies == null) {
            this.fireFlies = new ArrayList<List<GuiFirefly>>();
            for (int i = 0; i < 3; ++i) {
                this.fireFlies.add(new ArrayList());
            }
        }
        this.field_146292_n.clear();
        int j = this.field_146295_m / 4 + 48;
        this.field_146292_n.add(new GuiButtonMainMenu(1, this.field_146294_l / 2 - 100, j, I18n.func_135052_a((String)"menu.singleplayer", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonMainMenu(2, this.field_146294_l / 2 - 100, j + 24, I18n.func_135052_a((String)"menu.multiplayer", (Object[])new Object[0])));
        this.realmsButton = new GuiButtonMainMenu(14, this.field_146294_l / 2 + 2, j + 48, 98, 20, I18n.func_135052_a((String)"menu.online", (Object[])new Object[0]).replace("Minecraft", "").trim());
        this.field_146292_n.add(this.realmsButton);
        this.modButton = new GuiButtonMainMenu(6, this.field_146294_l / 2 - 100, j + 48, 98, 20, I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0]));
        this.field_146292_n.add(this.modButton);
        this.field_146292_n.add(new GuiButtonMainMenu(5, this.field_146294_l / 2 - 124, j + 72 + 12, 20, 20, "L"));
        this.field_146292_n.add(new GuiButtonMainMenu(0, this.field_146294_l / 2 - 100, j + 72 + 12, 98, 20, I18n.func_135052_a((String)"menu.options", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonMainMenu(4, this.field_146294_l / 2 + 2, j + 72 + 12, 98, 20, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0])));
        this.modUpdateNotification = NotificationModUpdateScreen.init((GuiMainMenu)this, (GuiButton)this.modButton);
        for (int i = 0; i < this.layerTextures.length; ++i) {
            this.layerTextures[i] = new ResourceLocation("thebetweenlands", "textures/gui/main/layer_" + i + ".png");
        }
        if (this.starfieldTextureFBO != null) {
            this.starfieldTextureFBO.func_147608_a();
            this.starfieldTextureFBO = null;
        }
        if (this.starfieldEffect != null) {
            this.starfieldEffect.delete();
            this.starfieldEffect = null;
        }
        if (ShaderHelper.INSTANCE.canUseShaders()) {
            this.starfieldTextureFBO = new Framebuffer(this.field_146294_l, this.field_146295_m, false);
            this.starfieldEffect = (Starfield)new Starfield(false).init();
            this.starfieldEffect.setTimeScale(5.0E-11f).setZoom(4.8f);
        }
    }

    public void func_146281_b() {
        if (this.starfieldTextureFBO != null) {
            this.starfieldTextureFBO.func_147608_a();
            this.starfieldTextureFBO = null;
        }
        if (this.starfieldEffect != null) {
            this.starfieldEffect.delete();
            this.starfieldEffect = null;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        ISaveFormat isaveformat;
        WorldInfo worldinfo;
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiOptions((GuiScreen)this, this.field_146297_k.field_71474_y));
        }
        if (button.field_146127_k == 5) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLanguage((GuiScreen)this, this.field_146297_k.field_71474_y, this.field_146297_k.func_135016_M()));
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldSelection((GuiScreen)this));
        }
        if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer((GuiScreen)this));
        }
        if (button.field_146127_k == 14 && this.realmsButton.field_146125_m) {
            RealmsBridge realmsbridge = new RealmsBridge();
            realmsbridge.switchToRealms((GuiScreen)this);
        }
        if (button.field_146127_k == 4) {
            this.field_146297_k.func_71400_g();
        }
        if (button.field_146127_k == 6) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiModList((GuiScreen)this));
        }
        if (button.field_146127_k == 11) {
            this.field_146297_k.func_71371_a("Demo_World", "Demo_World", DemoWorldServer.field_73071_a);
        }
        if (button.field_146127_k == 12 && (worldinfo = (isaveformat = this.field_146297_k.func_71359_d()).func_75803_c("Demo_World")) != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"selectWorld.deleteQuestion", (Object[])new Object[0]), "'" + worldinfo.func_76065_j() + "' " + I18n.func_135052_a((String)"selectWorld.deleteWarning", (Object[])new Object[0]), I18n.func_135052_a((String)"selectWorld.deleteButton", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), 12));
        }
    }

    public void func_73876_c() {
        ++this.layerTick;
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        for (int i = 0; i < 3; ++i) {
            List<GuiFirefly> layer = this.fireFlies.get(i);
            Iterator<GuiFirefly> it = layer.iterator();
            while (it.hasNext()) {
                GuiFirefly firefly = it.next();
                if (firefly.getPosY() >= (float)(res.func_78328_b() + 40) || firefly.getPosY() <= -40.0f || firefly.getPosX() <= -40.0f) {
                    it.remove();
                    continue;
                }
                firefly.update();
            }
            if (this.random.nextInt(32) != 0 || layer.size() >= 5) continue;
            layer.add(new GuiFirefly(res.func_78326_a() + 50, this.random.nextInt(this.field_146295_m), -this.random.nextFloat() * 0.8f, (this.random.nextFloat() - this.random.nextFloat()) * 1.5f));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiBLMainMenu.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16773120);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawStarfield(partialTicks);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        for (int i = 0; i < this.layerTextures.length; ++i) {
            if (i >= 1) {
                List<GuiFirefly> layer = this.fireFlies.get(i - 1);
                for (GuiFirefly firefly : layer) {
                    firefly.drawFireFly(this.field_146297_k, partialTicks);
                }
            }
            ResourceLocation layerTexture = this.layerTextures[i];
            this.field_146297_k.func_110434_K().func_110577_a(layerTexture);
            double u = (((float)this.layerTick + partialTicks) / (float)(this.layerTextures.length - i) / (float)(i + 1) + (float)(1024 * i) / 4.0f) / 4000.0f;
            double visibleU = (double)this.field_146294_l / (double)this.field_146295_m * (256.0 / (1024.0 * (double)i));
            double x = 0.0;
            double y = 0.0;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x + 0.0, y + (double)this.field_146295_m, (double)this.field_73735_i).func_187315_a(u, 1.0).func_181675_d();
            buffer.func_181662_b(x + (double)this.field_146294_l, y + (double)this.field_146295_m, (double)this.field_73735_i).func_187315_a(u + visibleU, 1.0).func_181675_d();
            buffer.func_181662_b(x + (double)this.field_146294_l, y + 0.0, (double)this.field_73735_i).func_187315_a(u + visibleU, 0.0).func_181675_d();
            buffer.func_181662_b(x + 0.0, y + 0.0, (double)this.field_73735_i).func_187315_a(u, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179090_x();
        GuiBLMainMenu.func_73734_a((int)0, (int)(this.field_146295_m - 30), (int)this.field_146294_l, (int)this.field_146295_m, (int)0x60000000);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.field_146297_k.func_110434_K().func_110577_a(LOGO_TEXTURE);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 80, 20.0f + MathHelper.func_76126_a((float)(((float)this.layerTick + partialTicks) / 16.0f)) * 6.0f, 0.0, 0.0, 161.0, 79.0, 256.0, 256.0);
        this.func_73729_b(0, 0, 239, 0, 17, 16);
        for (GuiButton button : this.field_146292_n) {
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        ForgeHooksClient.renderMainMenu((GuiMainMenu)this, (FontRenderer)this.field_146289_q, (int)this.field_146294_l, (int)this.field_146295_m, (String)"");
        List brandings = Lists.reverse((List)FMLCommonHandler.instance().getBrandings(true));
        for (int brdline = 0; brdline < brandings.size(); ++brdline) {
            String brd = (String)brandings.get(brdline);
            if (Strings.isNullOrEmpty((String)brd)) continue;
            this.func_73731_b(this.field_146289_q, brd, 2, this.field_146295_m - (10 + brdline * (this.field_146289_q.field_78288_b + 1)), 0xFFFFFF);
        }
        this.modUpdateNotification.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.field_146289_q, "Copyright Mojang AB. Do not distribute!", this.field_146294_l - this.field_146289_q.func_78256_a("Copyright Mojang AB. Do not distribute!") - 2, this.field_146295_m - 10, -1);
    }

    protected void drawStarfield(float partialTicks) {
        if (ShaderHelper.INSTANCE.canUseShaders() && this.starfieldEffect != null && this.starfieldTextureFBO != null) {
            this.starfieldEffect.setOffset(((float)this.layerTick + partialTicks) / 8000.0f, 0.0f, 0.0f);
            int renderDimension = Math.max(this.field_146294_l, this.field_146295_m);
            this.starfieldEffect.create(this.starfieldTextureFBO).setPreviousFramebuffer(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(renderDimension, renderDimension).render(partialTicks);
            GlStateManager.func_179144_i((int)this.starfieldTextureFBO.field_147617_g);
            GL11.glBegin((int)4);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)0.0, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glEnd();
        }
    }

    protected void drawTexturedModalRect(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight) {
        double uscale = 1.0 / textureWidth;
        double vscale = 1.0 / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x + 0.0, y + height, (double)this.field_73735_i).func_187315_a(u * uscale, (v + height) * vscale).func_181675_d();
        buffer.func_181662_b(x + width, y + height, (double)this.field_73735_i).func_187315_a((u + width) * uscale, (v + height) * vscale).func_181675_d();
        buffer.func_181662_b(x + width, y + 0.0, (double)this.field_73735_i).func_187315_a((u + width) * uscale, v * vscale).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, (double)this.field_73735_i).func_187315_a(u * uscale, v * vscale).func_181675_d();
        tessellator.func_78381_a();
    }
}

