/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio;

import java.util.function.Predicate;
import net.minecraft.client.audio.ISound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.SafeStreamSound;

@SideOnly(value=Side.CLIENT)
public class TileEntitySound<T extends TileEntity>
extends SafeStreamSound {
    public final T tile;
    public final BlockPos pos;
    public final Predicate<T> isPlaying;
    private boolean fadeOut = false;

    public TileEntitySound(SoundEvent sound, SoundCategory category, T tile, Predicate<T> isPlaying) {
        super(sound, category);
        this.field_147659_g = true;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.tile = tile;
        this.isPlaying = isPlaying;
        this.pos = tile.func_174877_v();
        this.field_147660_d = (float)this.pos.func_177958_n() + 0.5f;
        this.field_147661_e = (float)this.pos.func_177956_o() + 0.5f;
        this.field_147658_f = (float)this.pos.func_177952_p() + 0.5f;
    }

    @Override
    public void func_73660_a() {
        if (this.fadeOut || this.tile == null || !this.tile.func_145830_o() || !this.tile.func_145831_w().func_175667_e(this.tile.func_174877_v()) || this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v()) != this.tile || !this.isPlaying.test(this.tile)) {
            this.field_147659_g = false;
            this.fadeOut = true;
            this.field_147662_b -= 0.05f;
            if (this.field_147662_b <= 0.0f) {
                this.field_147668_j = true;
            }
        }
    }

    public void stopImmediately() {
        this.field_147668_j = true;
        this.field_147659_g = false;
    }

    public void stop() {
        this.fadeOut = true;
    }

    public void cancelFade() {
        this.fadeOut = false;
    }

    public boolean isStopping() {
        return this.field_147668_j || this.fadeOut;
    }
}

