/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.misc;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Fog {
    protected FogType type;
    protected float density;
    protected float red;
    protected float green;
    protected float blue;
    protected float colorMultiplier;
    protected float start;
    protected float end;
    protected float colorIncrement;
    protected float distanceIncrementMultiplier;
    protected float densityIncrement;

    public Fog(FogType type, float density, float red, float green, float blue, float colorMultiplier, float start, float end, float colorIncrement, float distanceIncrementMultiplier, float densityIncrement) {
        this.type = type;
        this.density = density;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.start = start;
        this.end = end;
        this.colorIncrement = colorIncrement;
        this.distanceIncrementMultiplier = distanceIncrementMultiplier;
        this.densityIncrement = densityIncrement;
        this.colorMultiplier = colorMultiplier;
    }

    public Fog(FogType type, float density, float red, float green, float blue, float colorMultiplier, float start, float end) {
        this(type, density, red, green, blue, colorMultiplier, start, end, 0.001f, 1.0f, 1.0f);
    }

    public Fog(Fog fog) {
        this(fog.type, fog.density, fog.red, fog.green, fog.blue, fog.colorMultiplier, fog.start, fog.end, fog.colorIncrement, fog.distanceIncrementMultiplier, fog.densityIncrement);
    }

    public float getColorIncrement() {
        return this.colorIncrement;
    }

    public float getDistanceIncrementMultiplier() {
        return this.distanceIncrementMultiplier;
    }

    public float getDensityIncrement() {
        return this.densityIncrement;
    }

    public FogType getFogType() {
        return this.type;
    }

    @SideOnly(value=Side.CLIENT)
    public int getGlFogType() {
        switch (this.type) {
            default: {
                return 9729;
            }
            case EXP: {
                return 2048;
            }
            case EXP2: 
        }
        return 2049;
    }

    public float getDensity() {
        return this.density;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getColorMultiplier() {
        return this.colorMultiplier;
    }

    public float getStart() {
        return this.start;
    }

    public float getEnd() {
        return this.end;
    }

    public static class MutableFog
    extends Fog {
        public MutableFog(FogType type, float density, float red, float green, float blue, float colorMultiplier, float start, float end) {
            super(type, density, red, green, blue, colorMultiplier, start, end);
        }

        public MutableFog(FogType type, float density, float red, float green, float blue, float colorMultiplier, float start, float end, float colorIncrement, float distanceIncrementMultiplier, float densityIncrement) {
            super(type, density, red, green, blue, colorMultiplier, start, end, colorIncrement, distanceIncrementMultiplier, densityIncrement);
        }

        public MutableFog(Fog fog) {
            super(fog);
        }

        public MutableFog() {
            super(FogType.LINEAR, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.001f, 1.0f, 1.0f);
        }

        public MutableFog setColorIncrement(float increment) {
            this.colorIncrement = increment;
            return this;
        }

        public MutableFog setDistanceIncrementMultiplier(float multiplier) {
            this.distanceIncrementMultiplier = multiplier;
            return this;
        }

        public MutableFog setDensityIncrement(float increment) {
            this.densityIncrement = increment;
            return this;
        }

        public MutableFog setType(FogType type) {
            this.type = type;
            return this;
        }

        public MutableFog setDensity(float density) {
            this.density = density;
            return this;
        }

        public MutableFog setRed(float red) {
            this.red = red;
            return this;
        }

        public MutableFog setGreen(float green) {
            this.green = green;
            return this;
        }

        public MutableFog setBlue(float blue) {
            this.blue = blue;
            return this;
        }

        public MutableFog setStart(float start) {
            this.start = start;
            return this;
        }

        public MutableFog setEnd(float end) {
            this.end = end;
            return this;
        }

        public MutableFog setColorMultiplier(float multiplier) {
            this.colorMultiplier = multiplier;
            return this;
        }

        public MutableFog set(Fog fog) {
            this.setType(fog.type).setDensity(fog.density).setRed(fog.getRed()).setGreen(fog.getGreen()).setBlue(fog.getBlue()).setStart(fog.start).setEnd(fog.end).setColorIncrement(fog.getColorIncrement()).setDistanceIncrementMultiplier(fog.getDistanceIncrementMultiplier()).setDensityIncrement(fog.getDensityIncrement());
            return this;
        }

        public Fog toImmutable() {
            return new Fog(this);
        }
    }

    public static enum FogType {
        LINEAR,
        EXP,
        EXP2;

    }
}

