/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.item;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.registries.CapabilityRegistry;

public interface IEquippable {
    public EnumEquipmentInventory getEquipmentCategory(ItemStack var1);

    public boolean canEquipOnRightClick(ItemStack var1, EntityPlayer var2, Entity var3);

    public boolean canEquip(ItemStack var1, @Nullable EntityPlayer var2, Entity var3);

    public boolean canUnequip(ItemStack var1, @Nullable EntityPlayer var2, Entity var3, IInventory var4);

    public boolean canDrop(ItemStack var1, Entity var2, IInventory var3);

    public void onEquip(ItemStack var1, Entity var2, IInventory var3);

    public void onUnequip(ItemStack var1, Entity var2, IInventory var3);

    public void onEquipmentTick(ItemStack var1, Entity var2, IInventory var3);

    public static void addEquippedPropertyOverrides(Item item) {
        item.func_185043_a(new ResourceLocation("equipped"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (stack.func_77973_b() instanceof IEquippable && entity != null && entity.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
                    IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
                    IInventory inv = cap.getInventory(((IEquippable)stack.func_77973_b()).getEquipmentCategory(stack));
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        if (stack != inv.func_70301_a(i)) continue;
                        return 1.0f;
                    }
                }
                return 0.0f;
            }
        });
    }
}

