/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.NBTHelper;
import thebetweenlands.util.config.ConfigHandler;

public class CorrosionHelper {
    public static final int CORROSION_STAGE_COUNT = 6;
    public static final String ITEM_CORROSION_NBT_TAG = "Corrosion";
    public static final String ITEM_COATING_NBT_TAG = "Coating";

    public static void addCorrosionPropertyOverrides(Item item) {
        item.func_185043_a(new ResourceLocation("corrosion"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return CorrosionHelper.getCorrosionStage(stack);
            }
        });
    }

    public static float getModifier(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ICorrodible) {
            ICorrodible corrodible = (ICorrodible)stack.func_77973_b();
            return -0.7f * ((float)corrodible.getCorrosion(stack) / (float)corrodible.getMaxCorrosion(stack)) + 1.0f;
        }
        return 1.0f;
    }

    public static float getStrVsBlock(float normalStrength, ItemStack itemStack, IBlockState blockState) {
        return normalStrength * CorrosionHelper.getModifier(itemStack);
    }

    public static boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || !CorrosionHelper.areItemStackTagsEqual(newStack, oldStack) || !newStack.func_77984_f() && newStack.func_77960_j() != oldStack.func_77960_j();
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || !CorrosionHelper.areItemStackTagsEqual(newStack, oldStack) || !newStack.func_77984_f() && newStack.func_77960_j() != oldStack.func_77960_j();
    }

    public static boolean areItemStackTagsEqual(ItemStack oldStack, ItemStack newStack) {
        return NBTHelper.areItemStackTagsEqual(newStack, oldStack, (Collection<String>)ImmutableList.of((Object)ITEM_CORROSION_NBT_TAG, (Object)ITEM_COATING_NBT_TAG));
    }

    public static Multimap<String, AttributeModifier> getAttributeModifiers(Multimap<String, AttributeModifier> map, EntityEquipmentSlot slot, ItemStack stack, UUID uuid, float damageVsEntity) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuid, "Tool modifier", (double)(damageVsEntity * CorrosionHelper.getModifier(stack)), 0));
        }
        return map;
    }

    public static void updateCorrosion(ItemStack stack, World world, Entity holder, int slot, boolean isHeldItem) {
        ICorrodible corrodible;
        int corrosion;
        if (!(world.field_72995_K || holder.field_71093_bK != ConfigHandler.dimensionId || holder instanceof EntityPlayer && ((EntityPlayer)holder).func_184812_l_() || stack == null || !(stack.func_77973_b() instanceof ICorrodible) || (corrosion = (corrodible = (ICorrodible)stack.func_77973_b()).getCorrosion(stack)) >= corrodible.getMaxCorrosion(stack))) {
            float probability;
            float f = probability = holder.func_70090_H() ? 0.0014f : 7.0E-4f;
            if (holder instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)holder;
                probability *= isHeldItem && player.func_184607_cu() != null ? 2.8f : 1.0f;
                if (player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
                    IDecayCapability decay = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
                    float playerCorruption = (float)decay.getDecayStats().getDecayLevel() / 20.0f;
                    probability = (float)((double)probability * (1.0 - Math.pow(playerCorruption, 2.0) * (double)0.9f));
                }
            }
            if (world.field_73012_v.nextFloat() < probability) {
                int coating = corrodible.getCoating(stack);
                if (coating > 0) {
                    corrodible.setCoating(stack, coating - 1);
                } else {
                    corrodible.setCorrosion(stack, corrosion + 1);
                }
            }
        }
    }

    public static void addCorrosionTooltips(ItemStack stack, EntityPlayer player, List<String> lines, boolean advancedItemTooltips) {
        if (stack != null && stack.func_77973_b() instanceof ICorrodible) {
            ICorrodible corrodible = (ICorrodible)stack.func_77973_b();
            int corrosion = corrodible.getCorrosion(stack);
            int coating = corrodible.getCoating(stack);
            StringBuilder corrosionInfo = new StringBuilder("tooltip.corrosion.");
            corrosionInfo.append(CorrosionHelper.getCorrosionStage(corrosion));
            corrosionInfo.replace(0, corrosionInfo.length(), I18n.func_135052_a((String)corrosionInfo.toString(), (Object[])new Object[0]));
            if (advancedItemTooltips) {
                corrosionInfo.append(" (");
                corrosionInfo.append(corrosion);
                corrosionInfo.append("/" + corrodible.getMaxCorrosion(stack) + ")");
            }
            lines.add(corrosionInfo.toString());
            StringBuilder coatingInfo = new StringBuilder("tooltip.coated.");
            coatingInfo.append(coating / 120);
            coatingInfo.replace(0, coatingInfo.length(), I18n.func_135052_a((String)coatingInfo.toString(), (Object[])new Object[0]));
            if (coating > 0 || advancedItemTooltips) {
                if (advancedItemTooltips) {
                    coatingInfo.append(" (");
                    coatingInfo.append(coating);
                    coatingInfo.append("/" + corrodible.getMaxCoating(stack) + ")");
                }
                lines.add(coatingInfo.toString());
            }
        }
    }

    public static int getCorrosionStage(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ICorrodible) {
            ICorrodible corrodible = (ICorrodible)stack.func_77973_b();
            return CorrosionHelper.getCorrosionStage(corrodible.getCorrosion(stack));
        }
        return 0;
    }

    public static int getCorrosionStage(int corrosion) {
        return (10 * corrosion + 630) / 635;
    }
}

