/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.aspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.item.IDiscoveryProvider;
import thebetweenlands.common.herblore.aspect.AspectManager;

public class DiscoveryContainer<T> {
    private final Map<AspectItem, List<IAspectType>> discoveredStaticAspects = new HashMap<AspectItem, List<IAspectType>>();
    private final IDiscoveryProvider<T> provider;
    private final T providerObj;

    public DiscoveryContainer(IDiscoveryProvider<T> provider, T providerObj) {
        this.provider = provider;
        this.providerObj = providerObj;
    }

    private DiscoveryContainer() {
        this.provider = null;
        this.providerObj = null;
    }

    public static DiscoveryContainer<?> empty() {
        return new DiscoveryContainer();
    }

    public static DiscoveryContainer<?> readFromNBT(NBTTagCompound nbt) {
        DiscoveryContainer<?> container = DiscoveryContainer.empty();
        container.updateFromNBT(nbt, false);
        return container;
    }

    private int getDiscoveryCount(AspectItem item) {
        return !this.discoveredStaticAspects.containsKey(item) ? 0 : this.discoveredStaticAspects.get(item).size();
    }

    private DiscoveryContainer<T> saveContainer() {
        if (this.provider != null && this.providerObj != null) {
            this.provider.saveContainer(this.providerObj, this);
        }
        return this;
    }

    public AspectDiscovery discover(AspectManager manager, AspectItem aspectItem) {
        List<Aspect> staticAspects = manager.getStaticAspects(aspectItem);
        if (staticAspects.isEmpty()) {
            return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.NONE, null, false);
        }
        int discoveryCount = this.getDiscoveryCount(aspectItem) + 1;
        if (discoveryCount > staticAspects.size()) {
            return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.END, null, false);
        }
        Aspect undiscovered = this.getUndiscoveredAspect(staticAspects, this.discoveredStaticAspects.get(aspectItem));
        this.addDiscovery(aspectItem, undiscovered.type);
        if (discoveryCount == staticAspects.size()) {
            this.saveContainer();
            return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.LAST, undiscovered, true);
        }
        this.saveContainer();
        return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.NEW, undiscovered, true);
    }

    public void discoverAll(AspectManager manager) {
        for (Map.Entry<AspectItem, List<Aspect>> e : manager.getMatchedAspects().entrySet()) {
            for (Aspect a : e.getValue()) {
                this.addDiscovery(e.getKey(), a.type);
            }
        }
        this.saveContainer();
    }

    public void resetDiscovery(AspectItem item) {
        this.discoveredStaticAspects.remove(item);
        this.saveContainer();
    }

    public void resetAllDiscovery() {
        this.discoveredStaticAspects.clear();
        this.saveContainer();
    }

    public void addDiscovery(AspectItem item, IAspectType discovered) {
        List<IAspectType> discoveredAspects = this.discoveredStaticAspects.get(item);
        if (discoveredAspects == null) {
            discoveredAspects = new ArrayList<IAspectType>();
            this.discoveredStaticAspects.put(item, discoveredAspects);
        }
        if (!discoveredAspects.contains(discovered)) {
            discoveredAspects.add(discovered);
        }
        this.saveContainer();
    }

    private Aspect getUndiscoveredAspect(List<Aspect> all, List<IAspectType> discovered) {
        if (discovered == null) {
            return all.size() == 0 ? null : all.get(0);
        }
        for (Aspect a : all) {
            if (discovered.contains(a.type)) continue;
            return a;
        }
        return null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList discoveryList = new NBTTagList();
        Iterator<Map.Entry<AspectItem, List<IAspectType>>> discoveryIT = this.discoveredStaticAspects.entrySet().iterator();
        while (discoveryIT.hasNext()) {
            Map.Entry<AspectItem, List<IAspectType>> e = discoveryIT.next();
            if (e.getKey() == null || e.getValue() == null || e.getValue().size() == 0) {
                discoveryIT.remove();
                continue;
            }
            NBTTagCompound discoveryEntry = new NBTTagCompound();
            AspectManager.writeAspectItemToNbt(e.getKey(), discoveryEntry);
            NBTTagList aspectListCompound = new NBTTagList();
            for (IAspectType type : e.getValue()) {
                aspectListCompound.func_74742_a((NBTBase)type.writeToNBT(new NBTTagCompound()));
            }
            discoveryEntry.func_74782_a("aspects", (NBTBase)aspectListCompound);
            discoveryList.func_74742_a((NBTBase)discoveryEntry);
        }
        nbt.func_74782_a("discoveries", (NBTBase)discoveryList);
        return nbt;
    }

    public DiscoveryContainer<T> updateFromNBT(NBTTagCompound nbt, boolean save) {
        this.discoveredStaticAspects.clear();
        NBTTagList discoveryList = nbt.func_150295_c("discoveries", 10);
        int discoveryEntries = discoveryList.func_74745_c();
        for (int i = 0; i < discoveryEntries; ++i) {
            NBTTagCompound discoveryEntry = discoveryList.func_150305_b(i);
            AspectItem item = AspectManager.readAspectItemFromNBT(discoveryEntry);
            ArrayList<IAspectType> aspectTypeList = new ArrayList<IAspectType>();
            NBTTagList aspectListCompound = discoveryEntry.func_150295_c("aspects", 10);
            for (int c = 0; c < aspectListCompound.func_74745_c(); ++c) {
                NBTTagCompound aspectTypeCompound = aspectListCompound.func_150305_b(c);
                aspectTypeList.add(IAspectType.readFromNBT(aspectTypeCompound));
            }
            this.discoveredStaticAspects.put(item, aspectTypeList);
        }
        if (save) {
            this.saveContainer();
        }
        return this;
    }

    public DiscoveryContainer<T> mergeDiscoveries(DiscoveryContainer<?> other) {
        boolean changed = false;
        for (Map.Entry<AspectItem, List<IAspectType>> entry : other.discoveredStaticAspects.entrySet()) {
            AspectItem otherItem = entry.getKey();
            List<IAspectType> otherTypes = entry.getValue();
            if (!this.discoveredStaticAspects.containsKey(otherItem)) {
                this.discoveredStaticAspects.put(otherItem, otherTypes);
                changed = true;
                continue;
            }
            List<IAspectType> aspectTypes = this.discoveredStaticAspects.get(otherItem);
            for (IAspectType otherType : otherTypes) {
                if (aspectTypes.contains(otherType)) continue;
                aspectTypes.add(otherType);
                changed = true;
            }
        }
        if (changed) {
            this.saveContainer();
        }
        return this;
    }

    public List<Aspect> getDiscoveredStaticAspects(AspectManager manager, AspectItem item) {
        ArrayList<Aspect> discoveredStaticAspects = new ArrayList<Aspect>();
        if (this.discoveredStaticAspects.containsKey(item)) {
            List<IAspectType> discoveredAspects = this.discoveredStaticAspects.get(item);
            List<Aspect> staticAspects = manager.getStaticAspects(item);
            for (Aspect a : staticAspects) {
                if (!discoveredAspects.contains(a.type)) continue;
                discoveredStaticAspects.add(a);
            }
        }
        return discoveredStaticAspects;
    }

    public static boolean hasDiscoveryProvider(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IDiscoveryProvider)) continue;
            return true;
        }
        return false;
    }

    public static List<DiscoveryContainer<?>> getWritableDiscoveryContainers(EntityPlayer player) {
        ArrayList containerList = new ArrayList();
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            IDiscoveryProvider provider;
            DiscoveryContainer<ItemStack> container;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IDiscoveryProvider) || (container = (provider = (IDiscoveryProvider)stack.func_77973_b()).getContainer(stack)) == null) continue;
            containerList.add(container);
        }
        return containerList;
    }

    public static DiscoveryContainer<?> getMergedDiscoveryContainer(EntityPlayer player) {
        List<DiscoveryContainer<?>> containerList = DiscoveryContainer.getWritableDiscoveryContainers(player);
        DiscoveryContainer<?> merged = DiscoveryContainer.empty();
        for (DiscoveryContainer<?> container : containerList) {
            if (container == null) continue;
            merged.mergeDiscoveries(container);
        }
        return merged;
    }

    public static void addDiscoveryToContainers(EntityPlayer player, AspectItem item, IAspectType type) {
        List<DiscoveryContainer<?>> discoveryContainers = DiscoveryContainer.getWritableDiscoveryContainers(player);
        for (DiscoveryContainer<?> container : discoveryContainers) {
            container.addDiscovery(item, type);
        }
    }

    public static class AspectDiscovery {
        public final EnumDiscoveryResult result;
        public final boolean successful;
        public final Aspect discovered;

        private AspectDiscovery(EnumDiscoveryResult result, Aspect discovered, boolean successful) {
            this.result = result;
            this.discovered = discovered;
            this.successful = successful;
        }

        public static enum EnumDiscoveryResult {
            NONE,
            NEW,
            LAST,
            END;

        }
    }
}

