/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.aspect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.registries.AspectRegistry;

public class AspectContainer {
    private final Map<IAspectType, Storage> storage = new HashMap<IAspectType, Storage>();

    protected final Storage getStorage(IAspectType type) {
        Storage storage = this.storage.get(type);
        if (storage == null) {
            storage = new Storage(type, this);
            this.storage.put(type, storage);
        }
        return storage;
    }

    public AspectContainer() {
        for (IAspectType type : AspectRegistry.ASPECT_TYPES) {
            this.storage.put(type, new Storage(type, this));
        }
    }

    protected void onChanged() {
    }

    protected final ImmutableSet<IAspectType> getStoredAspectTypes() {
        return ImmutableSet.copyOf(this.storage.keySet());
    }

    protected final int get(IAspectType type, boolean dynamic) {
        return this.getStorage(type).getAmount(dynamic);
    }

    public final int get(IAspectType type) {
        Storage storage = this.getStorage(type);
        return storage.getAmount(true) + storage.getAmount(false);
    }

    public final Aspect getAspect(IAspectType type) {
        return new Aspect(type, this.get(type));
    }

    public final AspectContainer set(IAspectType type, int amount) {
        if (amount >= 0) {
            Storage storage = this.getStorage(type);
            int diff = this.get(type) - amount;
            if (diff > 0) {
                int dynAmounts = storage.getAmount(true);
                storage.setAmount(true, Math.max(dynAmounts - diff, 0));
                diff = Math.max(diff - dynAmounts, 0);
                if (diff > 0) {
                    storage.setAmount(false, storage.getAmount(false) - diff);
                }
                this.onChanged();
            } else if (diff < 0) {
                storage.setAmount(true, amount - storage.getAmount(false));
                this.onChanged();
            }
        }
        return this;
    }

    public final AspectContainer add(IAspectType type, int amount) {
        Storage storage;
        Storage storage2 = storage = this.getStorage(type);
        storage2.dynamicAmount = storage2.dynamicAmount + amount;
        if (amount != 0) {
            this.onChanged();
        }
        return this;
    }

    public final int drain(IAspectType type, int desiredAmount) {
        int amount = this.get(type);
        if (desiredAmount >= amount) {
            this.set(type, 0);
            return amount;
        }
        this.set(type, amount - desiredAmount);
        return desiredAmount;
    }

    public final boolean isEmpty() {
        for (Storage storage : this.storage.values()) {
            if (storage.getAmount(true) + storage.getAmount(false) <= 0) continue;
            return false;
        }
        return true;
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagList typesList = new NBTTagList();
        for (Map.Entry<IAspectType, Storage> entry : this.storage.entrySet()) {
            IAspectType type = entry.getKey();
            Storage storage = entry.getValue();
            if (storage.dynamicAmount == 0 && !storage.hasStoredStaticAmount) continue;
            NBTTagCompound storageNbt = new NBTTagCompound();
            storageNbt.func_74782_a("aspect", (NBTBase)type.writeToNBT(new NBTTagCompound()));
            storageNbt.func_74782_a("storage", (NBTBase)storage.writeToNBT(new NBTTagCompound()));
            typesList.func_74742_a((NBTBase)storageNbt);
        }
        nbt.func_74782_a("container", (NBTBase)typesList);
        return nbt;
    }

    public AspectContainer read(NBTTagCompound nbt) {
        NBTTagList typesList = nbt.func_150295_c("container", 10);
        for (int i = 0; i < typesList.func_74745_c(); ++i) {
            NBTTagCompound storageNbt = typesList.func_150305_b(i);
            IAspectType type = IAspectType.readFromNBT(storageNbt.func_74775_l("aspect"));
            if (type == null) continue;
            Storage storage = this.getStorage(type);
            storage.readFromNBT(storageNbt.func_74775_l("storage"));
        }
        return this;
    }

    @Nonnull
    protected List<Aspect> getStaticAspects() {
        return ImmutableList.of();
    }

    @Nonnull
    public List<Aspect> getAspects() {
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        ImmutableSet<IAspectType> types = this.getStoredAspectTypes();
        for (IAspectType type : types) {
            int amount = this.get(type);
            if (amount <= 0) continue;
            aspects.add(new Aspect(type, amount));
        }
        return aspects;
    }

    protected static final class Storage {
        private final IAspectType type;
        private final AspectContainer container;
        private int dynamicAmount;
        private int storedStaticAmount;
        private boolean hasStoredStaticAmount;

        private Storage(IAspectType type, AspectContainer container) {
            this.type = type;
            this.dynamicAmount = 0;
            this.storedStaticAmount = 0;
            this.hasStoredStaticAmount = false;
            this.container = container;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("dynamic", this.dynamicAmount);
            nbt.func_74768_a("storedStatic", this.storedStaticAmount);
            nbt.func_74757_a("hasStoredStatic", this.hasStoredStaticAmount);
            return nbt;
        }

        public Storage readFromNBT(NBTTagCompound nbt) {
            this.dynamicAmount = nbt.func_74762_e("dynamic");
            this.storedStaticAmount = nbt.func_74762_e("storedStatic");
            this.hasStoredStaticAmount = nbt.func_74767_n("hasStoredStatic");
            return this;
        }

        public int getAmount(boolean dynamic) {
            if (dynamic) {
                return this.dynamicAmount;
            }
            if (this.hasStoredStaticAmount) {
                return this.storedStaticAmount;
            }
            List<Aspect> staticAspects = this.container.getStaticAspects();
            if (staticAspects != null) {
                int amount = 0;
                for (Aspect aspect : staticAspects) {
                    if (aspect.type != this.type) continue;
                    amount += aspect.amount;
                }
                return amount;
            }
            return 0;
        }

        public Storage setAmount(boolean dynamic, int amount) {
            if (dynamic) {
                this.dynamicAmount = amount;
            } else {
                this.storedStaticAmount = amount;
                this.hasStoredStaticAmount = true;
            }
            return this;
        }

        public Storage resetStaticAmount() {
            this.storedStaticAmount = 0;
            this.hasStoredStaticAmount = false;
            return this;
        }
    }
}

