/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.aspect;

import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.registries.AspectRegistry;

public final class Aspect
implements Comparable<Aspect> {
    public final IAspectType type;
    public final int amount;

    public Aspect(IAspectType aspect, int amount) {
        if (aspect == null) {
            throw new RuntimeException("Aspect can't be null");
        }
        this.type = aspect;
        this.amount = amount;
    }

    public float getDisplayAmount() {
        return (float)this.amount / 100.0f;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("aspect", this.type.getName());
        nbt.func_74768_a("amount", this.amount);
        return nbt;
    }

    public static Aspect readFromNBT(NBTTagCompound nbt) {
        String aspectName = nbt.func_74779_i("aspect");
        int amount = nbt.func_74762_e("amount");
        IAspectType aspectType = AspectRegistry.getAspectTypeFromName(aspectName);
        if (aspectType != null) {
            return new Aspect(aspectType, amount);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.amount);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Aspect other = (Aspect)obj;
        if (Float.floatToIntBits(this.amount) != Float.floatToIntBits(other.amount)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public int compareTo(Aspect other) {
        return this.type.getName().compareTo(other.type.getName());
    }
}

