/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.harvest;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.iface.IHarvestHandler;
import WayofTime.bloodmagic.api.registry.HarvestRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HarvestHandlerPlantable
implements IHarvestHandler {
    public HarvestHandlerPlantable() {
        HarvestRegistry.registerStandardCrop(Blocks.field_150459_bM, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_150464_aj, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_150469_bN, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_185773_cZ, 3);
        HarvestRegistry.registerStandardCrop(Blocks.field_150388_bm, 3);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "blockFlax", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "blockCanola", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "blockRice", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "redorchid", 6);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "enderlily", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "moonglow", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "terra_moss", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "pereskia", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "wildroot", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "aubergine", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "spirit_herb", 7);
        HarvestHandlerPlantable.addPamCrops();
    }

    @Override
    public boolean harvestAndPlant(World world, BlockPos pos, BlockStack blockStack) {
        if (!HarvestRegistry.getStandardCrops().containsKey(blockStack.getBlock())) {
            return false;
        }
        int matureMeta = HarvestRegistry.getStandardCrops().get(blockStack.getBlock());
        if (blockStack.getMeta() < matureMeta) {
            return false;
        }
        List drops = blockStack.getBlock().getDrops((IBlockAccess)world, pos, blockStack.getState(), 0);
        boolean foundSeed = false;
        for (ItemStack stack : drops) {
            if (stack == null || !(stack.func_77973_b() instanceof IPlantable)) continue;
            --stack.field_77994_a;
            foundSeed = true;
            break;
        }
        if (foundSeed) {
            world.func_175656_a(pos, blockStack.getBlock().func_176223_P());
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockStack.getState()));
            for (ItemStack stack : drops) {
                if (stack == null || stack.field_77994_a <= 0 || world.field_72995_K) continue;
                EntityItem toDrop = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), stack);
                world.func_72838_d((Entity)toDrop);
            }
            return true;
        }
        return false;
    }

    private static void addThirdPartyCrop(String modid, String regName, int matureMeta) {
        if (!Loader.isModLoaded((String)modid)) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, regName));
        if (block != null && block != Blocks.field_150350_a) {
            HarvestRegistry.registerStandardCrop(block, matureMeta);
        }
    }

    private static void addPamCrops() {
        if (!Loader.isModLoaded((String)"harvestcraft")) {
            return;
        }
        try {
            ClassLoader loader = HarvestHandlerPlantable.class.getClassLoader();
            String className = "com.pam.harvestcraft.blocks.CropRegistry";
            Class registry = ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{className});
            Field names = ReflectionHelper.findField((Class)registry, (String[])new String[]{"cropNames"});
            Method getCrop = registry.getMethod("getCrop", String.class);
            for (String name : (String[])names.get(null)) {
                BlockCrops crop = (BlockCrops)getCrop.invoke(null, name);
                HarvestRegistry.registerStandardCrop((Block)crop, crop.func_185526_g());
            }
        }
        catch (NoSuchMethodException e) {
            BloodMagic.instance.getLogger().error("HarvestCraft integration cancelled; unable to find crop name mapper", new Object[0]);
            return;
        }
        catch (IllegalAccessException e) {
            BloodMagic.instance.getLogger().error("HarvestCraft integration cancelled; crop name lookup broke", new Object[0]);
            return;
        }
        catch (InvocationTargetException e) {
            BloodMagic.instance.getLogger().error("HarvestCraft integration cancelled; crop name lookup broke", new Object[0]);
            return;
        }
        catch (ReflectionHelper.UnableToFindClassException e) {
            BloodMagic.instance.getLogger().error("HarvestCraft integration cancelled; unable to find crop registry", new Object[0]);
            return;
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            BloodMagic.instance.getLogger().error("HarvestCraft integration cancelled; unable to find crop names in registry", new Object[0]);
            return;
        }
    }
}

