/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualZephyr
extends Ritual {
    public static final String ZEPHYR_RANGE = "zephyrRange";
    public static final String CHEST_RANGE = "chest";

    public RitualZephyr() {
        super("ritualZephyr", 0, 1000, "ritual.BloodMagic.zephyrRitual");
        this.addBlockRange(ZEPHYR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(ZEPHYR_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntity tileInventory = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
        if (!masterRitualStone.getWorldObj().field_72995_K && tileInventory != null) {
            if (currentEssence < this.getRefreshCost()) {
                masterRitualStone.getOwnerNetwork().causeNausea();
                return;
            }
            AreaDescriptor zephyrRange = this.getBlockRange(ZEPHYR_RANGE);
            List itemList = world.func_72872_a(EntityItem.class, zephyrRange.getAABB(masterRitualStone.getBlockPos()));
            int count = 0;
            if (itemList != null) {
                for (EntityItem entityItem : itemList) {
                    if (entityItem.field_70128_L) continue;
                    ItemStack copyStack = entityItem.func_92059_d().func_77946_l();
                    int originalAmount = copyStack.field_77994_a;
                    ItemStack newStack = Utils.insertStackIntoTile(copyStack, tileInventory, EnumFacing.DOWN);
                    if (newStack != null && newStack.field_77994_a < originalAmount) {
                        ++count;
                        if (newStack.field_77994_a <= 0) {
                            entityItem.func_70106_y();
                        }
                        entityItem.func_92059_d().field_77994_a = newStack.field_77994_a;
                    }
                    if (newStack != null) continue;
                    entityItem.func_70106_y();
                }
            }
            masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost() * Math.min(count, 100));
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 1;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addParallelRunes(components, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 1, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, -1, EnumRuneType.AIR);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualZephyr();
    }
}

