/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeRepairing;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerRepairing
extends StatTracker {
    public double totalDamage = 0.0;
    public static HashMap<LivingArmour, Integer> changeMap = new HashMap();
    public static int[] damageRequired = new int[]{500};

    public static void incrementCounter(LivingArmour armour, int receivedDamage) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + receivedDamage : receivedDamage);
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.tracker.repair";
    }

    @Override
    public void resetTracker() {
        this.totalDamage = 0.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalDamage = tag.func_74769_h("BloodMagic.tracker.repair");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("BloodMagic.tracker.repair", this.totalDamage);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        double change;
        if (changeMap.containsKey(livingArmour) && (change = (double)Math.abs(changeMap.get(livingArmour))) > 0.0) {
            this.totalDamage += (double)Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 1; ++i) {
            if (!(this.totalDamage >= (double)damageRequired[i])) continue;
            upgradeList.add(new LivingArmourUpgradeRepairing(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalDamage, damageRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("BloodMagic.upgrade.repair");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeRepairing && (level = upgrade.getUpgradeLevel()) < damageRequired.length) {
            this.totalDamage = Math.max(this.totalDamage, (double)damageRequired[level]);
            this.markDirty();
        }
    }
}

