/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeArrowShot;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerArrowShot
extends StatTracker {
    public int totalShots = 0;
    public static HashMap<LivingArmour, Integer> changeMap = new HashMap();
    public static int[] shotsRequired = new int[]{50, 200, 700, 1500, 3000};

    public static void incrementCounter(LivingArmour armour) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + 1 : 1);
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.tracker.trickShot";
    }

    @Override
    public void resetTracker() {
        this.totalShots = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalShots = tag.func_74762_e("BloodMagic.tracker.trickShot");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("BloodMagic.tracker.trickShot", this.totalShots);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        int change;
        if (changeMap.containsKey(livingArmour) && (change = Math.abs(changeMap.get(livingArmour))) > 0) {
            this.totalShots += Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 5; ++i) {
            if (this.totalShots < shotsRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradeArrowShot(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalShots, shotsRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("BloodMagic.upgrade.arrowShot");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeArrowShot && (level = upgrade.getUpgradeLevel()) < shotsRequired.length) {
            this.totalShots = Math.max(this.totalShots, shotsRequired[level]);
            this.markDirty();
        }
    }
}

