/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.incense;

import WayofTime.bloodmagic.api.incense.EnumTranquilityType;
import WayofTime.bloodmagic.api.incense.ITranquilityHandler;
import WayofTime.bloodmagic.api.incense.TranquilityStack;
import WayofTime.bloodmagic.registry.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TranquilityHandlers {

    public static class Water
    implements ITranquilityHandler {
        @Override
        public TranquilityStack getTranquilityOfBlock(World world, BlockPos pos, Block block, IBlockState state) {
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                return new TranquilityStack(EnumTranquilityType.WATER, 1.0);
            }
            if (block == ModBlocks.LIFE_ESSENCE) {
                return new TranquilityStack(EnumTranquilityType.WATER, 1.5);
            }
            return null;
        }
    }

    public static class Tree
    implements ITranquilityHandler {
        @Override
        public TranquilityStack getTranquilityOfBlock(World world, BlockPos pos, Block block, IBlockState state) {
            if (block instanceof BlockLog) {
                return new TranquilityStack(EnumTranquilityType.TREE, 1.0);
            }
            return null;
        }
    }

    public static class Crop
    implements ITranquilityHandler {
        @Override
        public TranquilityStack getTranquilityOfBlock(World world, BlockPos pos, Block block, IBlockState state) {
            if (block == Blocks.field_150469_bN || block == Blocks.field_150459_bM || block == Blocks.field_150464_aj || block == Blocks.field_150388_bm || block == Blocks.field_185773_cZ) {
                return new TranquilityStack(EnumTranquilityType.CROP, 1.0);
            }
            return null;
        }
    }

    public static class Earth
    implements ITranquilityHandler {
        @Override
        public TranquilityStack getTranquilityOfBlock(World world, BlockPos pos, Block block, IBlockState state) {
            if (block == Blocks.field_150346_d) {
                return new TranquilityStack(EnumTranquilityType.EARTHEN, 0.25);
            }
            if (block instanceof BlockGrass) {
                return new TranquilityStack(EnumTranquilityType.EARTHEN, 0.5);
            }
            if (block == Blocks.field_150458_ak) {
                return new TranquilityStack(EnumTranquilityType.EARTHEN, 1.0);
            }
            return null;
        }
    }

    public static class Fire
    implements ITranquilityHandler {
        @Override
        public TranquilityStack getTranquilityOfBlock(World world, BlockPos pos, Block block, IBlockState state) {
            if (block instanceof BlockFire) {
                return new TranquilityStack(EnumTranquilityType.FIRE, 1.0);
            }
            if (block == Blocks.field_150424_aL) {
                return new TranquilityStack(EnumTranquilityType.FIRE, 0.5);
            }
            return null;
        }
    }

    public static class Lava
    implements ITranquilityHandler {
        @Override
        public TranquilityStack getTranquilityOfBlock(World world, BlockPos pos, Block block, IBlockState state) {
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                return new TranquilityStack(EnumTranquilityType.LAVA, 1.2);
            }
            return null;
        }
    }

    public static class Plant
    implements ITranquilityHandler {
        @Override
        public TranquilityStack getTranquilityOfBlock(World world, BlockPos pos, Block block, IBlockState state) {
            if (block instanceof BlockLeaves) {
                return new TranquilityStack(EnumTranquilityType.PLANT, 1.0);
            }
            return null;
        }
    }
}

